% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{normalize}
\alias{normalize}
\alias{normalize.dgCMatrix}
\alias{normalize.ligerDataset}
\alias{normalize.liger}
\alias{normalize.Seurat}
\alias{normalizePeak}
\title{Normalize raw counts data}
\usage{
normalize(object, ...)

\method{normalize}{dgCMatrix}(object, log = FALSE, scaleFactor = NULL, ...)

\method{normalize}{ligerDataset}(object, chunk = 1000, verbose = getOption("ligerVerbose", TRUE), ...)

\method{normalize}{liger}(
  object,
  useDatasets = NULL,
  verbose = getOption("ligerVerbose", TRUE),
  format.type = NULL,
  remove.missing = NULL,
  ...
)

\method{normalize}{Seurat}(object, assay = NULL, layer = "counts", save = "ligerNormData", ...)

normalizePeak(
  object,
  useDatasets = NULL,
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{object}{\linkS4class{liger} object}

\item{...}{Arguments to be passed to S3 methods. The "liger" method calls
the "ligerDataset" method, which then calls "dgCMatrix" method.
\code{normalizePeak} directly calls \code{normalize.dgCMatrix}.}

\item{log}{Logical. Whether to do a \code{log(x + 1)} transform on the
normalized data. Default \code{TRUE}.}

\item{scaleFactor}{Numeric. Scale the normalized expression value by this
factor before transformation. \code{NULL} for not scaling. Default
\code{1e4}.}

\item{chunk}{Integer. Number of maximum number of cells in each chunk when
working on HDF5 file based ligerDataset. Default \code{1000}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{useDatasets}{A character vector of the names, a numeric or logical
vector of the index of the datasets to be normalized. Should specify ATACseq
datasets when using \code{normalizePeak}. Default \code{NULL} normalizes all
valid datasets.}

\item{format.type, remove.missing}{\bold{Deprecated}. The functionality of
these is covered through other parts of the whole workflow and is no long
needed. Will be ignored if specified.}

\item{assay}{Name of assay to use. Default \code{NULL} uses current active
assay.}

\item{layer}{Where the input raw counts should be from. Default
\code{"counts"}. For older Seurat, always retrieve from \code{counts} slot.}

\item{save}{For Seurat>=4.9.9, the name of layer to store normalized data.
Default \code{"ligerNormData"}. For older Seurat, stored to \code{data} slot.}
}
\value{
Updated \code{object}.
\itemize{
 \item{dgCMatrix method - Returns processed dgCMatrix object}
 \item{ligerDataset method - Updates the \code{normData} slot of the object}
 \item{liger method - Updates the \code{normData} slot of chosen datasets}
 \item{Seurat method - Adds a named layer in chosen assay (V5), or update the
 \code{data} slot of the chosen assay (<=V4)}
 \item{\code{normalizePeak} - Updates the \code{normPeak} slot of chosen
 datasets.}
}
}
\description{
Perform library size normalization on raw counts input. As for
the preprocessing step of iNMF integration, by default we don't multiply the
normalized values with a scale factor, nor do we take the log transformation.
Applicable S3 methods can be found in Usage section.

\code{normalizePeak} is designed for datasets of "atac" modality, i.e. stored
in \linkS4class{ligerATACDataset}. S3 method for various container object is
not supported yet due to difference in architecture design.
}
\examples{
pbmc <- normalize(pbmc)
}
