% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGeneViolin}
\alias{plotGeneViolin}
\alias{plotTotalCountViolin}
\alias{plotGeneDetectedViolin}
\title{Visualize gene expression or cell metadata with violin plot}
\usage{
plotGeneViolin(object, gene, byDataset = TRUE, groupBy = NULL, ...)

plotTotalCountViolin(object, groupBy = "dataset", ...)

plotGeneDetectedViolin(object, groupBy = "dataset", ...)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{gene}{Character gene names.}

\item{byDataset}{Logical, whether the violin plot should be splitted by
dataset. Default \code{TRUE}.}

\item{groupBy}{Names of available categorical variable in \code{cellMeta}
slot. Use \code{FALSE} for no grouping. Default \code{NULL} looks clustering
result but will not group if no clustering found.}

\item{...}{Additional arguments passed to \code{\link{plotCellViolin}}.}
}
\value{
ggplot if using a single gene and not splitting by dataset.
Otherwise, list of ggplot.
}
\description{
Visualize gene expression or cell metadata with violin plot
}
\examples{
plotGeneViolin(pbmcPlot, varFeatures(pbmcPlot)[1],
               groupBy = "leiden_cluster")
plotTotalCountViolin(pbmc)
plotGeneDetectedViolin(pbmc, dot = TRUE, box = TRUE, colorBy = "dataset")
}
