% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list.class}
\alias{list.class}
\title{Classify list members into unique cases evaluated by given expression.}
\usage{
list.class(x, expr, sort.cases = TRUE, keep.case.names = TRUE,
  keep.item.names = TRUE)
}
\arguments{
\item{x}{The list to be classified}

\item{expr}{An expression that determines cases}

\item{sort.cases}{logical. if TRUE the cases will be sorted in ascending order.}

\item{keep.case.names}{Whether to keep the names of the cases}

\item{keep.item.names}{Whether to keep the names of the items in the result}
}
\description{
Classify list members into unique cases evaluated by given expression.
}
\examples{
\dontrun{
x <-
  list(
    p1=list(name="Ken",age=24,
      interest=c("reading","music","movies"),
      lang=list(r=2,csharp=4,python=3)),
    p2=list(name="James",age=25,
      interest=c("sports","music"),
      lang=list(r=3,java=2,cpp=5)),
    p3=list(name="Penny",age=24,
      interest=c("movies","reading"),
      lang=list(r=1,cpp=4,python=2)))
list.class(x,interest)
list.class(x,names(lang))
}
}

