context("Test sigymake")

test_that("sigymake returns correct covariance matrix", {
  schools = 2
  sections = 2
  students = 2
  
  I = schools
  r = rep(sections, schools)
  m = matrix(students, nrow=schools, ncol=sections)
  
  sigma = sigymake(I, r, m, 1, 1, 1)
  
  expect_equal(sigma$sigy2, matrix(c(
      3,    2,    1,    1,    0,    0,    0,    0,
      2,    3,    1,    1,    0,    0,    0,    0,
      1,    1,    3,    2,    0,    0,    0,    0,
      1,    1,    2,    3,    0,    0,    0,    0,
      0,    0,    0,    0,    3,    2,    1,    1,
      0,    0,    0,    0,    2,    3,    1,    1,
      0,    0,    0,    0,    1,    1,    3,    2,
      0,    0,    0,    0,    1,    1,    2,    3
    ), ncol=8, nrow=8))
  
  expect_equal(sigma$sigy12i, matrix(c(
    0.73882869, -0.26117131, -0.04984645, -0.04984645,  0.00000000,  0.00000000,  0.00000000,  0.00000000,
    -0.26117131,  0.73882869, -0.04984645, -0.04984645,  0.00000000,  0.00000000,  0.00000000,  0.00000000,
    -0.04984645, -0.04984645,  0.73882869, -0.26117131,  0.00000000,  0.00000000,  0.00000000,  0.00000000,
    -0.04984645, -0.04984645, -0.26117131,  0.73882869,  0.00000000,  0.00000000,  0.00000000,  0.00000000,
    0.00000000,  0.00000000,  0.00000000,  0.00000000,  0.73882869, -0.26117131, -0.04984645, -0.04984645,
    0.00000000,  0.00000000,  0.00000000,  0.00000000, -0.26117131,  0.73882869, -0.04984645, -0.04984645,
    0.00000000,  0.00000000,  0.00000000,  0.00000000, -0.04984645, -0.04984645,  0.73882869, -0.26117131,
    0.00000000,  0.00000000,  0.00000000,  0.00000000, -0.04984645, -0.04984645, -0.26117131,  0.73882869
  ), ncol=8, nrow=8))
})