% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{sc_CAR1}
\alias{sc_CAR1}
\title{Simulating Count Data From The Output of Real Data Analysis}
\usage{
sc_CAR1(BetaMat, Sigma2Vec, RhoVec, WeightMat, lib.size, design, Subject,
  Time, nrep)
}
\arguments{
\item{BetaMat}{a matrix of estimates of regression coefficients.}

\item{Sigma2Vec}{a vector of shrinkage estimates of error variances.}

\item{RhoVec}{a vector of estimates of correlation.}

\item{WeightMat}{a matrix of weights of all genes obtaining from voom.}

\item{lib.size}{library size in voom method, we choose .75 quantile as library
size.}

\item{design}{a design matrix.}

\item{Subject}{a vector of subjects/experimental units.}

\item{Time}{a vector of time points.}

\item{nrep}{simulation iteration.}
}
\value{
a matrix of count data that has nrow(BetaMat) rows and nrow(design)
 columns.
}
\description{
This function generates bootstrap samples using parametric bootstrap method.
}
\examples{
\donttest{
data(res)
v <- res$ori.res$v[1:50,]
newlm <- res$ori.res$newlm[1:50,]
BetaMat <- data.matrix(newlm[grep("fixed.", names(newlm))])
Sigma2Vec <- newlm$s2_shrunken
RhoVec <- newlm$rho
WeightMat <- v$weights
lib.size <- v$targets$lib.size
nrep <- 1
Subject <- covset$ear
Time <- covset$time
simcounts <- rmRNAseq:::sc_CAR1(BetaMat, Sigma2Vec, RhoVec, WeightMat,
lib.size, design, Subject, Time)
dim(simcounts)
}
}
\references{
Yet Nguyen, Dan Nettleton, 2019. rmRNAseq: RNA-seq Analysis for Repeated-measures Data.
}
