% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststat.R
\name{teststat}
\alias{teststat}
\title{Calculating F-Type Statistics To Test a General Linear Hypothesis}
\usage{
teststat(C.matrix, beta0 = NULL, regression.output, ncores = 1)
}
\arguments{
\item{C.matrix}{is a list of matrix Ci in testing H0:  Ci*beta = 0.}

\item{beta0}{vector of the hypothesized value of beta, usually, beta0 is a 0
vector. The default option \code{beta0 = NULL} means that \code{beta0} is a
vector of 0.}

\item{regression.output}{this is a data.frame containing the output of
\code{\link{glsCAR1}} function for all G genes.}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}
}
\value{
A matrix of dimension G X length(C.matrix) of F-similar test
  statistics
}
\description{
This function is to calculate F-type test statistics for a general linear
hypothesis for each of G genes.
}
\examples{
\donttest{
data(design)
beta0 <- NULL
regression.output <- res$ori.res$newlm[1:50,]
ncores <- 1
C.matrix <- list()
C.matrix[[1]] <- limma::makeContrasts(line2, levels = design)
C.matrix[[2]] <- limma::makeContrasts(time2, time6, time24, levels = design)
names(C.matrix) <- c("line2","time")
teststatout <- rmRNAseq:::teststat(C.matrix, beta0, regression.output, ncores)
head(teststatout)
}
}
