% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_datasets.R
\name{search_datasets}
\alias{search_datasets}
\title{Query datasets}
\usage{
search_datasets(query, verbose = TRUE, ...)
}
\arguments{
\item{query}{either a character string including a single keyword or a named list containing a custom query (see details section below).
Note that if an empty character string is passed, then all datasets available are returned.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
An object of class \code{mgSearchDatasets}, which basically is a \code{data.frame}
object including all datasets corresponding to the query. For each dataset
entry,  the networks and the original reference are attached.
}
\description{
Identify relevant datasets using a keyword or a custom query.
If the \code{query} is a character string, then all character columns in the table
are searched and the entries for which at least one
partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a specific column (see Details section)
}
\details{
If \code{query} is a named list, the name  used should be one of the following:
\itemize{
\item id: unique identifier of the dataset
\item name: name of the dataset
\item date: date (\code{YYYY-mm-dd}) of the corresponding publication
\item description: a brief description of the data set
\item ref_id: the Mangal identifier of the dataset
}

Note that for lists with more than one element, only the first element is used, the others are ignored.
Examples covering custom queries are provided below.
}
\examples{
\donttest{
 # Return all datasets (takes time)
 all_datasets <- search_datasets("")
 all_datasets
 class(all_datasets)
 # Search with keyword
 mg_lagoon <- search_datasets(query = 'lagoon')
 # Search with a custom query (specific column)
 mg_kemp <- search_datasets(query = list(name = 'kemp_1977'))
 mg_16 <- search_datasets(query = list(ref_id = 16))
}
}
\references{
\itemize{
\item \url{https://mangal.io/#/}
\item \url{https://mangal-interactions.github.io/mangal-api/#datasets}
}
}
