% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_networks.R
\name{search_networks}
\alias{search_networks}
\alias{search_networks_sf}
\title{Query networks}
\usage{
search_networks(query, verbose = TRUE, ...)

search_networks_sf(query_sf, verbose = TRUE, ...)
}
\arguments{
\item{query}{either a character string including a single keyword or a named list containing a custom query (see details section below), or a spatial object (see the description of \code{query_sf}).
Note that if an empty character string is passed, then all datasets available are returned.}

\item{verbose}{a \code{logical}. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}

\item{query_sf}{a spatial object of class \code{sf} used to search in a specific geographical area.}
}
\value{
An object of class \code{mgSearchNetworks}, which is a \code{data.frame} object with all networks informations
}
\description{
Search over all networks using a keyword, a custom query or a spatial object
If the \code{query} is a character string, then all character columns in the table
are searched and the entries for which at least one
partial match was found are returned.
Alternatively, a named list can be used to look for an exact match in a specific column (see Details section)
}
\details{
Names of the list should match one of the column names within the table.
For the \code{networks} table, those are
\itemize{
\item id: unique identifier of the network;
\item all_interactions: false interaction can be considered as real false interaction
\item dataset_id: the identifier of the dataset;
\item public: network publicly available;
}

Note that for lists with more than one element, only the first element is used, the others are ignored. An example is provided below.
}
\section{Functions}{
\itemize{
\item \code{search_networks_sf()}: Search networks within a spatial object passed as an argument. Note that \code{sf} must be installed to use this function.

}}
\examples{
\donttest{
 mg_insect <- search_networks(query="insect\%")
 # Retrieve the search results
 nets_insect <- get_collection(mg_insect)
 # Spatial query
 library(sf)
 library(USAboundaries)
 area <- us_states(state="california")
 networks_in_area <- search_networks_sf(area, verbose = FALSE)
 plot(networks_in_area)
 # Retrieve network ID 5013
 net_5013 <- search_networks(query = list(id = 5013))
 # Network(s) of dataset ID 19
 mg_19 <- search_networks(list(dataset_id = 19))
}

}
\references{
\itemize{
\item \url{https://mangal.io/#/}
\item \url{https://mangal-interactions.github.io/mangal-api/#networks}
}
}
