/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.chartPanel;

import dmLab.gui.chartPanel.DataSeries;
import dmLab.gui.chartPanel.LineChart;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class JLineChart
extends LineChart {
    private XYSeriesCollection myDataset;
    private ArrayList<Boolean> seriesMainAxisIndicator;
    private Color[] colors = new Color[]{Color.red, Color.blue, Color.black, Color.green, Color.magenta, Color.yellow, Color.orange, Color.gray};
    private boolean axis2ON = true;

    /*
     * WARNING - void declaration
     */
    public JLineChart(String chartTitle, int imageWidth, int imageHeight) {
        super((String)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BufferedImage draw(ArrayList<DataSeries> series) {
        int i = 0;
        while (i < series.size()) {
            DataSeries s = series.get(i);
            if (i == 0) {
                this.addSeries(s.seriesTitle, s.x, s.y, s.mainAxis, true);
            } else {
                void var3_3;
                this.addSeries(s.seriesTitle, s.x, s.y, var3_3.mainAxis, false);
            }
            ++i;
        }
        return this.redraw();
    }

    @Override
    public final BufferedImage redraw() {
        XYSeries xYSeries;
        XYSeriesCollection xYSeriesCollection;
        if (this.myDataset == null) {
            return null;
        }
        JLineChart jLineChart = this;
        XYSeriesCollection xYSeriesCollection2 = jLineChart.myDataset;
        jLineChart = this;
        int n = 0;
        int n2 = 0;
        if (xYSeriesCollection2.getSeriesCount() > 1) {
            n2 = 1;
        }
        XYSeriesCollection xYSeriesCollection3 = null;
        if (jLineChart.axis2ON) {
            xYSeriesCollection = new XYSeriesCollection();
            xYSeriesCollection3 = new XYSeriesCollection();
            int n3 = xYSeriesCollection2.getSeriesCount();
            int n4 = 0;
            while (n4 < n3) {
                xYSeries = xYSeriesCollection2.getSeries(n4);
                if (jLineChart.seriesMainAxisIndicator.get(n4).booleanValue()) {
                    xYSeriesCollection.addSeries(xYSeries);
                } else {
                    xYSeriesCollection3.addSeries(xYSeries);
                }
                ++n4;
            }
        } else {
            xYSeriesCollection = xYSeriesCollection2;
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)jLineChart.chartTitle, (String)jLineChart.xLabel, (String)jLineChart.yLabel, (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, n2 != 0, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint((Paint)Color.lightGray);
        xYPlot.setDomainGridlinePaint((Paint)Color.white);
        xYPlot.setRangeGridlinePaint((Paint)Color.white);
        xYSeries = new XYLineAndShapeRenderer();
        int n5 = xYSeriesCollection.getSeriesCount();
        n2 = 0;
        while (n2 < n5) {
            xYSeries.setSeriesPaint(n2, (Paint)jLineChart.colors[n++]);
            xYSeries.setSeriesLinesVisible(n2, true);
            xYSeries.setSeriesShapesVisible(n2, false);
            ++n2;
        }
        xYPlot.setRenderer((XYItemRenderer)xYSeries);
        Object object = (NumberAxis)xYPlot.getRangeAxis();
        object.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (jLineChart.axis2ON) {
            n5 = xYSeriesCollection3.getSeriesCount();
            object = "";
            int n6 = 0;
            while (n6 < n5) {
                xYSeries = xYSeriesCollection3.getSeries(n6);
                if (n6 != 0) {
                    object = String.valueOf(object) + "/";
                }
                object = String.valueOf(object) + xYSeries.getDescription();
                ++n6;
            }
            NumberAxis numberAxis = new NumberAxis(String.valueOf(object) + " values");
            numberAxis.setAutoRangeIncludesZero(false);
            xYPlot.setRangeAxis(1, (ValueAxis)numberAxis);
            xYPlot.setDataset(1, (XYDataset)xYSeriesCollection3);
            xYPlot.mapDatasetToRangeAxis(1, 1);
            xYSeries = new XYLineAndShapeRenderer();
            int n7 = 0;
            while (n7 < n5) {
                xYSeries.setSeriesPaint(n7, (Paint)jLineChart.colors[n++]);
                xYSeries.setSeriesLinesVisible(n7, true);
                xYSeries.setSeriesShapesVisible(n7, false);
                ++n7;
            }
            xYPlot.setRenderer(1, (XYItemRenderer)xYSeries);
        }
        jLineChart = jFreeChart;
        return jLineChart.createBufferedImage(this.imgWidth, this.imgHeight, null);
    }

    private void addSeries(String seriesTitle, float[] x, float[] y, boolean mainAxis, boolean flushDataset) {
        if (flushDataset || this.myDataset == null) {
            this.myDataset = new XYSeriesCollection();
            this.seriesMainAxisIndicator = new ArrayList();
        }
        XYSeries series = new XYSeries((Comparable)((Object)seriesTitle));
        series.setDescription(seriesTitle);
        int i = 0;
        while (i < x.length) {
            series.add((double)x[i], (double)y[i]);
            ++i;
        }
        this.myDataset.addSeries(series);
        this.seriesMainAxisIndicator.add(mainAxis);
    }
}

