/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor.panels;

import dmLab.array.loader.fileLoader.FileType;
import dmLab.gui.dataEditor.components.GlyphButton;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.fileFilters.MyFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class AttrFilterPanel
extends JPanel
implements ActionListener {
    private JButton browseButton;
    private JTextField filePath;
    public GlyphButton filterButton;
    private JComboBox measureName;
    private JTextField attrNumber;
    private JCheckBox inverseCheckBox;
    private JFileChooser fileDialog;
    public AttributesRI importances;

    public AttrFilterPanel() {
        this.initFilterPanel();
    }

    private void initFilterPanel() {
        this.setPreferredSize(new Dimension(301, 119));
        this.setLayout(null);
        this.fileDialog = new JFileChooser();
        MyFileFilter[] fileFilters = FileType.getSupportedTypes();
        int i = 0;
        while (i < fileFilters.length) {
            this.fileDialog.addChoosableFileFilter(fileFilters[i]);
            ++i;
        }
        this.inverseCheckBox = new JCheckBox();
        this.add(this.inverseCheckBox);
        this.inverseCheckBox.setText("Inverse");
        this.inverseCheckBox.setBounds(91, 84, 70, 28);
        this.inverseCheckBox.setSelected(false);
        this.attrNumber = new JTextField();
        this.add(this.attrNumber);
        this.attrNumber.setText("30");
        this.attrNumber.setBounds(20, 84, 63, 28);
        this.browseButton = new JButton();
        this.add(this.browseButton);
        this.browseButton.setText("Browse");
        this.browseButton.setBounds(210, 7, 91, 28);
        this.filePath = new JTextField();
        this.add(this.filePath);
        this.filePath.setText("Histogram file path");
        this.filePath.setBounds(15, 10, 190, 30);
        this.filterButton = new GlyphButton("images/filter.jpg", "Filter Attributes");
        this.filterButton.setToolTipText("Filter Attributes.");
        this.add(this.filterButton);
        this.filterButton.setBounds(210, 50, 90, 40);
        this.browseButton.addActionListener(this);
        this.measureName = new JComboBox();
        this.add(this.measureName);
        this.measureName.setModel(new DefaultComboBoxModel<String>(new String[]{"RI"}));
        this.measureName.setBounds(15, 50, 190, 30);
        this.init();
    }

    public final boolean inverseFiltering() {
        return this.inverseCheckBox.isSelected();
    }

    public final String getMeasureName() {
        return (String)this.measureName.getModel().getSelectedItem();
    }

    public final int getAttrNumber() {
        return Integer.parseInt(this.attrNumber.getText());
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        int n;
        Object object = event.getSource();
        if (object == this.browseButton && (n = ((AttrFilterPanel)object).fileDialog.showOpenDialog((Component)(object = this))) == 0) {
            Serializable serializable = ((AttrFilterPanel)object).fileDialog.getSelectedFile();
            System.out.println("Opening: " + ((File)serializable).getName());
            ((AttrFilterPanel)object).importances = new AttributesRI();
            if (((AttrFilterPanel)object).importances.load(((File)serializable).getAbsolutePath())) {
                System.out.println("Histogram file loaded.");
                ((AttrFilterPanel)object).filePath.setText(((File)serializable).getAbsolutePath());
                serializable = new DefaultComboBoxModel<String>(((AttrFilterPanel)object).importances.getMeasuresNames());
                ((AttrFilterPanel)object).measureName.setModel(serializable);
                object = ((AttrFilterPanel)object).importances.getMeasuresNames()[((AttrFilterPanel)object).importances.getMeasuresNames().length - 1];
                serializable.setSelectedItem(object);
                return;
            }
            System.err.println("Error loading histogram file.");
        }
    }

    public final void init() {
        this.importances = null;
        this.attrNumber.setText("30");
        this.filePath.setText("Histogram file path");
        this.measureName.setModel(new DefaultComboBoxModel<String>(new String[]{"RI_u1.0_v1.0"}));
        this.inverseCheckBox.setSelected(false);
    }
}

