/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

public class NormDiscrete
extends Expression {
    private static final long serialVersionUID = -8854409417983908220L;
    protected String m_fieldName;
    protected Attribute m_field;
    protected int m_fieldIndex = -1;
    protected String m_fieldValue;
    protected boolean m_mapMissingDefined = false;
    protected double m_mapMissingTo;
    protected int m_fieldValueIndex = -1;

    public NormDiscrete(Element normDisc, FieldMetaInfo.Optype opType, ArrayList<Attribute> fieldDefs) throws Exception {
        super(opType, fieldDefs);
        if (opType != FieldMetaInfo.Optype.CONTINUOUS) {
            throw new Exception("[NormDiscrete] can only have a continuous optype");
        }
        this.m_fieldName = normDisc.getAttribute("field");
        this.m_fieldValue = normDisc.getAttribute("value");
        String mapMissing = normDisc.getAttribute("mapMissingTo");
        if (mapMissing != null && mapMissing.length() > 0) {
            this.m_mapMissingTo = Double.parseDouble(mapMissing);
            this.m_mapMissingDefined = true;
        }
        this.setUpField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        super.setFieldDefs(fieldDefs);
        this.setUpField();
    }

    private void setUpField() throws Exception {
        this.m_fieldIndex = -1;
        this.m_fieldValueIndex = -1;
        this.m_field = null;
        if (this.m_fieldDefs != null) {
            this.m_fieldIndex = this.getFieldDefIndex(this.m_fieldName);
            if (this.m_fieldIndex < 0) {
                throw new Exception("[NormDiscrete] Can't find field " + this.m_fieldName + " in the supplied field definitions.");
            }
            this.m_field = (Attribute)this.m_fieldDefs.get(this.m_fieldIndex);
            if (!this.m_field.isString() && !this.m_field.isNominal()) {
                throw new Exception("[NormDiscrete] reference field " + this.m_fieldName + " must be categorical");
            }
            if (this.m_field.isNominal()) {
                this.m_fieldValueIndex = this.m_field.indexOfValue(this.m_fieldValue);
                if (this.m_fieldValueIndex < 0) {
                    throw new Exception("[NormDiscrete] Unable to find value " + this.m_fieldValue + " in nominal attribute " + this.m_field.name());
                }
            } else if (this.m_field.isString()) {
                this.m_fieldValueIndex = this.m_field.addStringValue(this.m_fieldValue);
            }
        }
    }

    @Override
    protected Attribute getOutputDef() {
        return new Attribute(String.valueOf(this.m_fieldName) + "=" + this.m_fieldValue);
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        double result = 0.0;
        if (Instance.isMissingValue(incoming[this.m_fieldIndex])) {
            result = this.m_mapMissingDefined ? this.m_mapMissingTo : incoming[this.m_fieldIndex];
        } else if (this.m_fieldValueIndex == (int)incoming[this.m_fieldIndex]) {
            result = 1.0;
        }
        return result;
    }

    @Override
    public String getResultCategorical(double[] incoming) throws Exception {
        throw new Exception("[NormDiscrete] Can't return the result as a categorical value!");
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append("NormDiscrete: " + this.m_fieldName + "=" + this.m_fieldValue);
        if (this.m_mapMissingDefined) {
            buff.append("\n" + pad + "map missing values to: " + this.m_mapMissingTo);
        }
        return buff.toString();
    }
}

