% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_main.R
\name{plot_roc_components}
\alias{plot_roc_components}
\title{Plot the components of a ROC curve by the high risk thresholds.}
\usage{
plot_roc_components(x, cost.benefit.axis = TRUE, n.cost.benefits = 6,
  cost.benefits, confidence.intervals, col = "black", lty.fpr = 2,
  lty.tpr = 1, lwd = 2, xlim, ylim, xlab = "Risk Threshold", ylab,
  cost.benefit.xlab = "Cost:Benefit Ratio", legend.position = c("topright",
  "right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top",
  "none"), ...)
}
\arguments{
\item{x}{decision_curve object to plot. Assumes output from function 'decision_curve'}

\item{cost.benefit.axis}{logical (default TRUE) indicating whether to print an additional x-axis showing relative cost:benefit ratios in addition to risk thresholds.}

\item{n.cost.benefits}{number of cost:benefit ratios to print if cost.benefit.axis = TRUE (default n.cost.benefit = 6).}

\item{cost.benefits}{Character vector of the form c("c1:b1", "c2:b2", ..., "cn:bn") with integers ci, bi corresponding to specific cost:benefit ratios to print. Default allows the function to calculate these automatically.}

\item{confidence.intervals}{logical indicating whether to plot confidence intervals.}

\item{col}{vector of length two indicating the color for the true positive rates and false positive rates, respectively.}

\item{lty.fpr}{linetype for the false positive rate curve.}

\item{lty.tpr}{linetype for the true positive rate curve.}

\item{lwd}{vector of linewidths. The first element corresponds to the tpr and the second to the fpr.}

\item{xlim}{vector giving c(min, max) of x-axis. Defaults to c(min(thresholds), max(thresholds)).}

\item{ylim}{vector giving c(min, max) of y-axis.}

\item{xlab}{label of main x-axis.}

\item{ylab}{label of y-axis.}

\item{cost.benefit.xlab}{label of cost:benefit ratio axis.}

\item{legend.position}{character vector giving position of legend. Options are "topright" (default), "right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top", or "none".}

\item{...}{other options directly send to plot()}
}
\description{
Plot the components of the ROC curve --the true positive rates and false positive rates-- by high risk thresholds.
}
\examples{
data(dcaData)
set.seed(123)
baseline.model <- decision_curve(Cancer~Age + Female + Smokes,
                                data = dcaData,
                                thresholds = seq(0, .4, by = .001),
                                bootstraps = 25) #should use more bootstrap replicates in practice!

#plot using the defaults
plot_roc_components(baseline.model,  xlim = c(0, 0.4), col = c("black", "red"))


}
