% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.decision_curve.R
\name{summary.decision_curve}
\alias{summary.decision_curve}
\title{Displays a useful description of a decision_curve object}
\usage{
\method{summary}{decision_curve}(object, ..., measure = c("sNB", "NB", "TPR",
  "FPR", "TNR", "FNR"), nround = 3)
}
\arguments{
\item{object}{decision_curve object to summarise}

\item{...}{other arguments ignored (for compatibility with generic)}

\item{measure}{name of summary measure to print out. For standardized net benefit: "sNB" (default), net benefit: "NB", true positive rate: "TPR", false positive rate: "FPR".}

\item{nround}{number of decimal places to round (default 3).}
}
\description{
Displays a useful description of a decision_curve object
}
\examples{
#helper function

#load simulated data
data(dcaData)

full.model <- decision_curve(Cancer~Age + Female + Smokes + Marker1 + Marker2,
data = dcaData,
thresholds = seq(0, .4, by = .05),
bootstraps = 25)

summary(full.model) #outputs standardized net benefit by default

summary(full.model, nround = 2, measure = "TPR")

}
