#' Recreation data from Value of Nature to Canadians Survey
#'
#' Data from 2000 individuals from the Value of Nature to Canadians (VNC) survey.
#' The travel costs are calculated using the approach described in Lloyd-Smith (2020)
#'
#' @docType data
#'
#' @usage data(data_rec)
#' @format A tibble with 34000 rows and 8 variables
#' @keywords datasets
#' @references Federal, Provincial, and Territorial Governments of Canada. 2014.
#' “2012 Canadian Nature Survey: Awareness, Participation, and Expenditures in Nature-Based Recreation, Conservation, and Subsistence Activities.” Ottawa, ON: Canadian Councils of Resource Ministers.
#' (\href{http://publications.gc.ca/site/eng/9.698872/publication.html}{PubMed})
#'
#' @references Lloyd-Smith, P (2020).
#' “The Economic Benefits of Recreation in Canada”. University of Saskatchewan Working Paper
#'
#' @source \href{http://donnees.ec.gc.ca/data/managementoversight/systems/canadian-nature-survey-2012/}{Canadian Nature Survey 2012}
"data_rec"
