% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{UnOp}
\alias{UnOp}
\title{UnOp}
\description{
Unary operation expression in MiniZinc
Possible unary operators are:
"+", "-", "not"
}
\examples{
newUnOp = UnOp$new(args = list(Int$new(5)), op = "-")
newUnOp$c_str()
newUnOp$setArg(1, Int$new(6))
newUnOp$setOp("+")
newUnOp$c_str()
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{UnOp}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.args}}{list of expression arguments}

\item{\code{.op}}{operator to be used}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.args}}{list of expression arguments}

\item{\code{.op}}{operator to be used}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{UnOp$new()}}
\item \href{#method-nargs}{\code{UnOp$nargs()}}
\item \href{#method-getArgs}{\code{UnOp$getArgs()}}
\item \href{#method-setArgs}{\code{UnOp$setArgs()}}
\item \href{#method-getArg}{\code{UnOp$getArg()}}
\item \href{#method-setArg}{\code{UnOp$setArg()}}
\item \href{#method-getOp}{\code{UnOp$getOp()}}
\item \href{#method-setOp}{\code{UnOp$setOp()}}
\item \href{#method-c_str}{\code{UnOp$c_str()}}
\item \href{#method-getDeleteFlag}{\code{UnOp$getDeleteFlag()}}
\item \href{#method-delete}{\code{UnOp$delete()}}
\item \href{#method-clone}{\code{UnOp$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$new(args, op)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{args}}{list of expressions}

\item{\code{op}}{unary operator}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nargs"></a>}}
\if{latex}{\out{\hypertarget{method-nargs}{}}}
\subsection{Method \code{nargs()}}{
get the number of arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$nargs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getArgs"></a>}}
\if{latex}{\out{\hypertarget{method-getArgs}{}}}
\subsection{Method \code{getArgs()}}{
get all expression arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$getArgs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setArgs"></a>}}
\if{latex}{\out{\hypertarget{method-setArgs}{}}}
\subsection{Method \code{setArgs()}}{
set all expression arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$setArgs()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{args}}{argument list to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getArg"></a>}}
\if{latex}{\out{\hypertarget{method-getArg}{}}}
\subsection{Method \code{getArg()}}{
get the ith expression argument
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$getArg(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setArg"></a>}}
\if{latex}{\out{\hypertarget{method-setArg}{}}}
\subsection{Method \code{setArg()}}{
set the ith expression argument
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$setArg(i, val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{val}}{value of expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getOp"></a>}}
\if{latex}{\out{\hypertarget{method-getOp}{}}}
\subsection{Method \code{getOp()}}{
get the unary operator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$getOp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setOp"></a>}}
\if{latex}{\out{\hypertarget{method-setOp}{}}}
\subsection{Method \code{setOp()}}{
set the unary operator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$setOp(unop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{unop}}{unary operator to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
return the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UnOp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
