% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{VarDecl}
\alias{VarDecl}
\title{VarDecl}
\description{
Contains different fields to create a variable declaration
}
\examples{
newVarDecl = VarDecl$new(name = "n", 
type_inst = TypeInst$new(Type$new(base_type = "int", kind = "par")))
newVarDecl$c_str()
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{VarDecl}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.ti}}{type instantiation information}

\item{\code{id}}{name of the variable}

\item{\code{.expression}}{the initialization expression}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.ti}}{type instantiation information}

\item{\code{id}}{name of the variable}

\item{\code{.expression}}{the initialization expression}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{VarDecl$new()}}
\item \href{#method-getId}{\code{VarDecl$getId()}}
\item \href{#method-setId}{\code{VarDecl$setId()}}
\item \href{#method-isPar}{\code{VarDecl$isPar()}}
\item \href{#method-isVar}{\code{VarDecl$isVar()}}
\item \href{#method-setDomain}{\code{VarDecl$setDomain()}}
\item \href{#method-getDomain}{\code{VarDecl$getDomain()}}
\item \href{#method-getValue}{\code{VarDecl$getValue()}}
\item \href{#method-setValue}{\code{VarDecl$setValue()}}
\item \href{#method-ti}{\code{VarDecl$ti()}}
\item \href{#method-c_str}{\code{VarDecl$c_str()}}
\item \href{#method-getDeleteFlag}{\code{VarDecl$getDeleteFlag()}}
\item \href{#method-delete}{\code{VarDecl$delete()}}
\item \href{#method-clone}{\code{VarDecl$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$new(name, type_inst, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the identifier/name}

\item{\code{type_inst}}{type instantiation of the variable}

\item{\code{value}}{value of variable, NULL by default}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getId"></a>}}
\if{latex}{\out{\hypertarget{method-getId}{}}}
\subsection{Method \code{getId()}}{
get the identifier object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$getId()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setId"></a>}}
\if{latex}{\out{\hypertarget{method-setId}{}}}
\subsection{Method \code{setId()}}{
set the identifier object name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$setId(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isPar"></a>}}
\if{latex}{\out{\hypertarget{method-isPar}{}}}
\subsection{Method \code{isPar()}}{
check if it's a parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$isPar()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isVar"></a>}}
\if{latex}{\out{\hypertarget{method-isVar}{}}}
\subsection{Method \code{isVar()}}{
check if it's a decision variable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$isVar()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDomain"></a>}}
\if{latex}{\out{\hypertarget{method-setDomain}{}}}
\subsection{Method \code{setDomain()}}{
overwrite the existing domain
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$setDomain(dom)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dom}}{domain expression to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDomain"></a>}}
\if{latex}{\out{\hypertarget{method-getDomain}{}}}
\subsection{Method \code{getDomain()}}{
get the variable domain
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$getDomain()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-getValue}{}}}
\subsection{Method \code{getValue()}}{
get the value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$getValue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setValue"></a>}}
\if{latex}{\out{\hypertarget{method-setValue}{}}}
\subsection{Method \code{setValue()}}{
set the value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$setValue(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{expression to be set (NULL to remove value)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ti"></a>}}
\if{latex}{\out{\hypertarget{method-ti}{}}}
\subsection{Method \code{ti()}}{
get the type-inst of the variable declaration
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$ti()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
get the domain of the variable


return string representation of MiniZinc
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VarDecl$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
