% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_monad-to-x.R
\name{as_dgr_graph}
\alias{as_dgr_graph}
\title{Convert a pipeline to DiagrammeR graph}
\usage{
as_dgr_graph(m, type = NULL, label = NULL, color = NULL, ...)
}
\arguments{
\item{m}{An Rmonad}

\item{type}{a function that will produce the type column for DiagrammeR}

\item{label}{a function that will produce the label column for DiagrammeR}

\item{color}{a function that sets the color of each node}

\item{...}{named functions that act on a monad to produce a scalar. These
functions will produce the attributes used in the graph object.}
}
\description{
WARNING: this pipeline handles parent/child relationships, but not the
subtly different 'branch' relationship. These should be resolvable to
parent/child relations.
}
\examples{
data(gff)
g <- as_dgr_graph(gff$good_result, mem=m_mem, time=m_time)
}
\seealso{
Other monad-to-x: \code{\link{esc}}, \code{\link{missues}},
  \code{\link{mreport}}, \code{\link{mtabulate}}
}
