% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_x-to-monad.R
\name{x_to_monad}
\alias{x_to_monad}
\alias{as_monad}
\alias{funnel}
\alias{combine}
\title{Conversions to monads}
\usage{
as_monad(expr, desc = NULL, doc = NULL, lossy = FALSE, clone = FALSE)

funnel(..., env = parent.frame(), keep_history = TRUE)

combine(xs, keep_history = TRUE, desc = NULL)
}
\arguments{
\item{expr}{An expression}

\item{desc}{A description of the monad (usually the producing code)}

\item{doc}{A docstring to associate with the monad}

\item{lossy}{logical Should unnesting with record be done?}

\item{clone}{logical Should the R6 object be cloned?}

\item{...}{multiple expressions}

\item{env}{Evaluation environment}

\item{keep_history}{Merge the histories of all monads}

\item{xs}{A list of elements to join into a monad}
}
\description{
These functions convert possibly non-monadic inputs into monads.
}
\details{
For each of these functions, failure of any part causes failure of the
whole. Any non-monadic inputs will be converted to monads. Any exceptions
raised in the inputs will be caught.

\code{as_monad} evaluate a single expression into an Rmonad. If the value is
already an Rmonad, it will be nested.

\code{funnel} evaluates multiple arguments into one Rmonad. It can be used
within pipelines to create multi-input nodes (works well with \code{\%*>\%}).

\code{combine} takes a list of Rmonads and joins the elements into one
Rmonad. The values of the original monadic containers joined into a list in
the child Rmonad. The list Rmonads are recorded as the new Rmonad's parents.
}
\examples{
as_monad(stop(1))
as_monad(1:10)
as_monad(5 \%>>\% sqrt)

## merge failing inputs 
funnel( 1:10, stop(1), sqrt(-3:3) )

## join pipelines
b2 <- letters[1:10] \%>>\% sqrt
b3 <- -3:6 \%>>\% log
1:10 \%>\% funnel(b2,b3) \%>>\%
  {data.frame(b1=.[[1]], b2=.[[2]], b3=.[[3]])}

z <- list(
  x = rnorm(10) \%>>\% sqrt,
  y = 1 \%>>\% colSums
)
combine(z)
}
