% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impactPO.r
\name{impactPO}
\alias{impactPO}
\title{Impact of Proportional Odds Assumpton}
\usage{
impactPO(
  formula,
  relax = if (missing(nonpo)) "multinomial" else "both",
  nonpo,
  newdata,
  data = environment(formula),
  B = 0,
  ...
)
}
\arguments{
\item{formula}{a model formula.  To work properly with \code{multinom} or \code{vglm} the terms should have completely specified knot locations if a spline function is being used.}

\item{relax}{defaults to \code{"both"} if \code{nonpo} is given, resulting in fitting two relaxed models.  Set \code{relax} to \code{"multinomial"} or \code{"ppo"} to fit only one relaxed model.  The multinomial model does not assume PO for any predictor.}

\item{nonpo}{a formula with no left hand side variable, specifying the variable or variables for which PO is not assumed.  Specifying \code{nonpo} results in a relaxed fit that is a partial PO model fitted with \code{VGAM::vglm}.}

\item{newdata}{a data frame or data table with one row per covariate setting for which predictions are to be made}

\item{data}{data frame containing variables to fit; default is the frame in which \code{formula} is found}

\item{B}{number of bootstrap resamples to do to get confidence intervals for differences in predicted probabilities for relaxed methods vs. PO model fits.  Default is not to run the bootstrap.  When running the bootstrap make sure that all model variables are explicitly in \verb{data=} so that selection of random subsets of data will call along the correct rows for all predictors.}

\item{...}{other parameters to pass to \code{lrm} and \code{multinom}}
}
\value{
an \code{impactPO} object which is a list with elements \code{estimates}, \code{stats}, \code{mad}, \code{newdata}, \code{nboot}, and \code{boot}.  \code{estimates} is a data frame containing the variables and values in \code{newdata} in a tall and thin format with additional variable \code{method} ("PO", "Multinomial", "PPO"), \code{y} (current level of the dependent variable), and \code{Probability} (predicted cell probability for covariate values and value of \code{y} in the current row).  \code{stats} is a data frame containing \code{Deviance} the model deviance, \code{d.f.} the total number of parameters counting intercepts, \code{AIC}, \code{p} the number of regression coefficients, \verb{LR chi^2} the likelihood ratio chi-square statistic for testing the predictors, \code{LR - p} a chance-corrected LR chi-square, \verb{LR chi^2 test for PO} the likelihood ratio chi-square test statistic for testing the PO assumption (by comparing -2 log likelihood for a relaxed model to that of a fully PO model), \code{  d.f.} the degrees of freedom for this test, \verb{  Pr(>chi^2)} the P-value for this test, \verb{MCS R2} the Maddala-Cox-Snell R2 using the actual sample size, \verb{MCS R2 adj} (\verb{MCS R2} adjusted for estimating \code{p} regression coefficients by subtracting \code{p} from \code{LR}), \verb{McFadden R2}, \verb{McFadden R2 adj} (an AIC-like adjustment proposed by McFadden without full justification), \verb{Mean |difference\} from PO} the overall mean absolute difference between predicted probabilities over all categories of Y and over all covariate settings.  \code{mad} contains \code{newdata} and separately by rows in \code{newdata} the mean absolute difference (over Y categories) between estimated probabilities by the indicated relaxed model and those from the PO model.  \code{nboot} is the number of successful bootstrap repetitions, and \code{boot} is a 4-way array with dimensions represented by the \code{nboot} resamples, the number of rows in \code{newdata}, the number of outcome levels, and elements for \code{PPO} and \code{multinomial}.  For the modifications of the Maddala-Cox-Snell indexes see \code{Hmisc::R2Measures}.
}
\description{
Checks the impact of the proportional odds assumption by comparing predicted cell probabilities from a PO model with those from a multinomial or partial proportional odds logistic model that relax assumptions.  For a given model formula, fits the model with both \code{lrm} and either \code{nnet::multinom} or \code{VGAM::vglm} or both, and obtains predicted cell probabilities for the PO and relaxed models on the \code{newdata} data frame.  A \code{print} method formats the output.
}
\examples{

\dontrun{
set.seed(1)
age <- rnorm(500, 50, 10)
sex <- sample(c('female', 'male'), 500, TRUE)
y   <- sample(0:4, 500, TRUE)
d   <- expand.grid(age=50, sex=c('female', 'male'))
w   <- impactPO(y ~ age + sex, nonpo = ~ sex, newdata=d)
w
# Note that PO model is a better model than multinomial (lower AIC)
# since multinomial model's improvement in fit is low in comparison
# with number of additional parameters estimated.  Same for PO model
# in comparison with partial PO model.

# Reverse levels of y so stacked bars have higher y located higher
revo <- function(z) {
  z <- as.factor(z)
  factor(z, levels=rev(levels(as.factor(z))))
}

ggplot(w$estimates, aes(x=method, y=Probability, fill=revo(y))) +
  facet_wrap(~ sex) + geom_col() +
  xlab('') + guides(fill=guide_legend(title=''))

# Now vary 2 predictors

d <- expand.grid(sex=c('female', 'male'), age=c(40, 60))
w <- impactPO(y ~ age + sex, nonpo = ~ sex, newdata=d)
w
ggplot(w$estimates, aes(x=method, y=Probability, fill=revo(y))) +
  facet_grid(age ~ sex) + geom_col() +
 xlab('') + guides(fill=guide_legend(title=''))
}
}
\references{
\href{https://hbiostat.org/bib/r2.html}{Adjusted R-square note}
}
\seealso{
\code{\link[nnet:multinom]{nnet::multinom()}}, \code{\link[VGAM:vglm]{VGAM::vglm()}}, \code{\link[=lrm]{lrm()}}, \code{\link[Hmisc:popower]{Hmisc::propsPO()}}, \code{\link[Hmisc:R2Measures]{Hmisc::R2Measures()}}
}
\author{
Frank Harrell \href{mailto:fh@fharrell.com}{fh@fharrell.com}
}
\keyword{category}
\keyword{models}
\keyword{regression}
