% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_normalise.R
\name{rmw_normalise}
\alias{rmw_normalise}
\title{Function to normalise a variable for "average" meteorological conditions.}
\usage{
rmw_normalise(
  model,
  df,
  variables = NA,
  n_samples = 300,
  replace = TRUE,
  se = FALSE,
  aggregate = TRUE,
  n_cores = NA,
  verbose = FALSE
)
}
\arguments{
\item{model}{A ranger model object from \code{\link{rmw_train_model}}.}

\item{df}{Input data used to calculate \code{model} using 
\code{\link{rmw_prepare_data}}.}

\item{variables}{Variables to randomly sample. Default is all variables used
for training the model with the exception of \code{date_unix}, the trend term.}

\item{n_samples}{Number of times to sample \code{df} and then predict?}

\item{replace}{Should \code{variables} be sampled with replacement?}

\item{se}{Should the standard error of the predictions be calculated too? 
The standard error method is the "infinitesimal jackknife for bagging" and 
will slow down the predictions significantly.}

\item{aggregate}{Should all the \code{n_samples} predictions be aggregated?}

\item{n_cores}{Number of CPU cores to use for the model predictions. Default
is system's total minus one.}

\item{verbose}{Should the function give messages?}
}
\value{
Tibble.
}
\description{
Function to normalise a variable for "average" meteorological conditions.
}
\examples{

\donttest{

# Load package
library(dplyr)

# Keep things reproducible
set.seed(123)

# Prepare example data
data_london_prepared <- data_london \%>\% 
  filter(variable == "no2") \%>\% 
  rmw_prepare_data()

# Normalise the example no2 data
data_normalised <- rmw_normalise(
  model_london, 
  df = data_london_prepared, 
  n_samples = 300,
  verbose = TRUE
)

}

}
\seealso{
\code{\link{rmw_prepare_data}}, \code{\link{rmw_train_model}}
}
\author{
Stuart K. Grange
}
