% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obo.R
\name{CV_}
\alias{CV_}
\title{CV_}
\description{
Define a Singleton class which can hold a CV dictionary (so we do not have to load the .obo files over and over again)
}
\details{
Get the full data by calling the 'getData()' function (which returns a list containing a 'CV', 'URI' and 'version'),
or 'getCV()' which is a shorthand for 'getData()$CV'.
You can set your own custom CV by calling 'setData()'. By default, the latest release of the PSI-MS-CV (see \code{\link{getCVDictionary}}).
Wherever you need this data, simply re-grab the singleton using 'CV_$new()' (or use the convenience function getCVSingleton() from outside the package)
}
\examples{
\dontrun{
  cv_dict = CV_$new() ## uses 'getCVDictionary()' to populate the singleton
  cv_2 = CV_$new() ## uses the same data without parsing again
  cv_2$setData(getCVDictionary("custom", "https://my.com/custom.obo"))
}

}
\section{Super class}{
\code{\link[R6P:Singleton]{R6P::Singleton}} -> \code{CV_}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CV_-ensureHasData}{\code{CV_$ensureHasData()}}
\item \href{#method-CV_-byID}{\code{CV_$byID()}}
\item \href{#method-CV_-setData}{\code{CV_$setData()}}
\item \href{#method-CV_-getData}{\code{CV_$getData()}}
\item \href{#method-CV_-getCV}{\code{CV_$getCV()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="R6P" data-topic="Singleton" data-id="initialize"><a href='../../R6P/html/Singleton.html#method-Singleton-initialize'><code>R6P::Singleton$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-ensureHasData"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-ensureHasData}{}}}
\subsection{Method \code{ensureHasData()}}{
Make sure that the CV data is loaded
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$ensureHasData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-byID"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-byID}{}}}
\subsection{Method \code{byID()}}{
A function to retrieve a CV entry using its ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$byID(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A CV accession, e.g. 'MS:1000560'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A CV term, or NULL if the ID is unknown
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-setData"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-setData}{}}}
\subsection{Method \code{setData()}}{
Set a user-defined object (= a list of 'CV', 'URI' and 'version'), as obtained from \code{\link{getCVDictionary}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$setData(cv_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cv_data}}{The result of a call to \code{\link{getCVDictionary}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-getData"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-getData}{}}}
\subsection{Method \code{getData()}}{
Gets the underlying data (CV, URI and version)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$getData()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-getCV"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-getCV}{}}}
\subsection{Method \code{getCV()}}{
A shorthand for 'getData()$CV', i.e. the CV data.frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$getCV()}\if{html}{\out{</div>}}
}

}
}
