% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_file_name.R
\name{ne_file_name}
\alias{ne_file_name}
\title{return a natural earth filename based on arguments}
\usage{
ne_file_name(
  scale = 110,
  type = "countries",
  category = c("cultural", "physical", "raster"),
  full_url = FALSE
)
}
\arguments{
\item{scale}{scale of map to return, one of \code{110}, \code{50}, \code{10}
or \code{'small'}, \code{'medium'}, \code{'large'}}

\item{type}{type of natural earth file to download one of 'countries',
'map_units', 'map_subunits', 'sovereignty', 'states' OR the portion of any
natural earth vector url after the scale and before the . e.g. for
'ne_50m_urban_areas.zip' this would be 'urban_areas' OR the raster
filename e.g. for 'MSR_50M.zip' this would be 'MSR_50M'}

\item{category}{one of natural earth categories : 'cultural', 'physical',
'raster'}

\item{full_url}{whether to return just the filename [default] or the full URL
needed for download}
}
\value{
string
}
\description{
returns a string that can then be used to download the file.
}
\examples{
ne_name <- ne_file_name(scale = 110, type = "countries")
ne_url <- ne_file_name(scale = 110, type = "countries", full_url = TRUE)

}
