% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncdc_datatypes.r
\name{ncdc_datatypes}
\alias{ncdc_datatypes}
\title{Get possible data types for a particular dataset}
\usage{
ncdc_datatypes(datasetid = NULL, datatypeid = NULL, datacategoryid = NULL,
  stationid = NULL, locationid = NULL, startdate = NULL, enddate = NULL,
  sortfield = NULL, sortorder = NULL, limit = 25, offset = NULL,
  token = NULL, dataset = NULL, page = NULL, filter = NULL, ...)
}
\arguments{
\item{datasetid}{(optional) Accepts a single valid dataset id. Data returned will be from the
dataset specified, see datasets()}

\item{datatypeid}{Accepts a valid data type id or a chain of data type ids in a
   comma-separated vector. Data returned will contain all of the data type(s) specified
(optional)}

\item{datacategoryid}{Optional. Accepts a valid data category id or a chain of data
category ids seperated by ampersands (although it is rare to have a data type
with more than one data category). Data types returned will be associated with
the data category(ies) specified}

\item{stationid}{Accepts a valid station id or a chain of of station ids in a
comma-separated vector. Data returned will contain data for the station(s) specified (optional)}

\item{locationid}{Accepts a valid location id or a chain of location ids in a
comma-separated vector. Data returned will contain data for the location(s) specified (optional)}

\item{startdate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data after the specified date. The
date range must be less than 1 year.}

\item{enddate}{(optional) Accepts valid ISO formated date (yyyy-mm-dd) or date time
(YYYY-MM-DDThh:mm:ss). Data returned will have data before the specified date. The
date range must be less than 1 year.}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's Climate
Data Online access token generator. (required) Get an API key (=token) at
http://www.ncdc.noaa.gov/cdo-web/token. You can pass your token in as
an argument or store it in your .Rprofile file with an entry like
\itemize{
  \item options("noaakey" = "your-noaa-token")
}}

\item{dataset}{THIS IS A DEPRECATED ARGUMENT. See datasetid.}

\item{page}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{filter}{THIS IS A DEPRECATED ARGUMENT. There is no equivalent argument in v2
of the NOAA API.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}} (optional)}
}
\value{
A \code{data.frame} for all datasets, or a list of length two, each with
   a data.frame.
}
\description{
From the NOAA API docs: Describes the type of data, acts as a label. If it's 64
degrees out right now, then the data type is Air Temperature and the data is 64.
}
\examples{
\dontrun{
# Fetch available data types
ncdc_datatypes()

# Fetch more information about the ACMH data type id
ncdc_datatypes(datatypeid="ACMH")

# Fetch data types with the air temperature data category
ncdc_datatypes(datacategoryid="TEMP", limit=56)

# Fetch data types that support a given set of stations
ncdc_datatypes(stationid=c('COOP:310090','COOP:310184','COOP:310212'))
}
}

