% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isd_read.R
\name{isd_read}
\alias{isd_read}
\title{Read NOAA ISD/ISH local file}
\usage{
isd_read(path, additional = TRUE, parallel = FALSE,
  cores = getOption("cl.cores", 2), progress = FALSE)
}
\arguments{
\item{path}{(character) path to the file. required.}

\item{additional}{(logical) include additional and remarks data sections
in output. Default: \code{TRUE}. Passed on to
\code{\link[isdparser]{isd_parse}}}

\item{parallel}{(logical) do processing in parallel. Default: \code{FALSE}}

\item{cores}{(integer) number of cores to use: Default: 2. We look in
your option "cl.cores", but use default value if not found.}

\item{progress}{(logical) print progress - ignored if \code{parallel=TRUE}.
The default is \code{FALSE} because printing progress adds a small bit of
time, so if processing time is important, then keep as \code{FALSE}}
}
\value{
A tibble (data.frame)
}
\description{
Read NOAA ISD/ISH local file
}
\details{
\code{isd_read} - read a \code{.gz} file as downloaded
from NOAA's website
}
\examples{
\dontrun{
file <- system.file("examples", "011490-99999-1986.gz", package = "rnoaa")
isd_read(file)
isd_read(file, additional = FALSE)
}
}
\references{
ftp://ftp.ncdc.noaa.gov/pub/data/noaa/
}
\seealso{
\code{\link{isd}}, \code{\link{isd_stations}},
\code{\link{isd_stations_search}}

Other isd: \code{\link{isd_stations_search}},
  \code{\link{isd_stations}}, \code{\link{isd}}
}
