% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn_data_download.R
\name{npn_download_individual_phenometrics}
\alias{npn_download_individual_phenometrics}
\title{Download Individual Phenometrics}
\usage{
npn_download_individual_phenometrics(
  request_source,
  years,
  period_start = "01-01",
  period_end = "12-31",
  coords = NULL,
  individual_ids = NULL,
  species_ids = NULL,
  station_ids = NULL,
  species_types = NULL,
  network_ids = NULL,
  states = NULL,
  phenophase_ids = NULL,
  functional_types = NULL,
  additional_fields = NULL,
  climate_data = FALSE,
  ip_address = NULL,
  dataset_ids = NULL,
  genus_ids = NULL,
  family_ids = NULL,
  order_ids = NULL,
  class_ids = NULL,
  pheno_class_ids = NULL,
  email = NULL,
  download_path = NULL,
  six_leaf_layer = FALSE,
  six_bloom_layer = FALSE,
  agdd_layer = NULL,
  six_sub_model = NULL,
  additional_layers = NULL,
  wkt = NULL
)
}
\arguments{
\item{request_source}{Required field, character Self-identify who is making
requests to the data service.}

\item{years}{Required field, character vector. Specify the years to include
in the search, e.g. \code{c('2013','2014')}. You must specify at least one year.}

\item{period_start, period_end}{Character vectors of the form "MM-DD". Used to
determine the period over which phenophase status records are summarized.
For example, to use a "water year" set \code{period_start = "10-01"} and
\code{period_end = "09-30"}. If not provided, they will default to "01-01" and
"12-31", respectively, to use the calendar year.}

\item{coords}{Numeric vector, used to specify a bounding box as a search
parameter, e.g. \code{c(lower_left_lat, lower_left_long, upper_right, lat,upper_right_long)}.}

\item{individual_ids}{Comma-separated string of unique IDs for individual
plants/animal species by which to filter the data.}

\item{species_ids}{Integer vector of unique IDs for searching based on
species, e.g. \code{c(3, 34, 35)}.}

\item{station_ids}{Integer vector of unique IDs for searching based on site
location, e.g. \code{c(5, 9)}.}

\item{species_types}{Character vector of unique species type names for
searching based on species types, e.g. \code{c("Deciduous", "Evergreen")}.}

\item{network_ids}{Integer vector of unique IDs for searching based on
partner group/network, e.g. \code{c(500, 300)}.}

\item{states}{Character vector of US postal states to be used as search
params, e.g. \code{c("AZ", "IL")}.}

\item{phenophase_ids}{Integer vector of unique IDs for searching based on
phenophase, e.g. \code{c(323, 324)}.}

\item{functional_types}{Character vector of unique functional type names,
e.g. `c("Birds").}

\item{additional_fields}{Character vector of additional fields to be included
in the search results, e.g. \code{c("Station_Name", "Plant_Nickname")}.}

\item{climate_data}{Boolean value indicating that all climate variables
should be included in \code{additional_fields}.}

\item{ip_address}{Optional field, string. IP Address of user requesting data.
Used for generating data reports.}

\item{dataset_ids}{Integer vector of unique IDs for searching based on
dataset, e.g. NEON or GRSM \code{c(17,15)}.}

\item{genus_ids}{Integer vector of unique IDs for searching based on
taxonomic family, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} is also set.}

\item{family_ids}{Integer vector of unique IDs for searching based on
taxonomic family, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} is also set.}

\item{order_ids}{Integer vector of unique IDs for searching based on
taxonomic order, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids} or \code{family_ids} are also set.}

\item{class_ids}{Integer vector of unique IDs for searching based on
taxonomic class, e.g. \code{c(3, 34, 35)}. This parameter will take precedence
if \code{species_ids}, \code{family_ids} or \code{order_ids} are also set.}

\item{pheno_class_ids}{Integer vector of unique IDs for searching based on
pheno class. Note that if both \code{pheno_class_id} and \code{phenophase_id} are
provided in the same request, \code{phenophase_id} will be ignored.}

\item{email}{Optional field, string. Email of user requesting data.}

\item{download_path}{Character, optional file path to the file for which to
output the results.}

\item{six_leaf_layer}{Boolean value when set to \code{TRUE} will attempt to
resolve the date of the observation to a spring index, leafing value for
the location at which the observations was taken.}

\item{six_bloom_layer}{Boolean value when set to \code{TRUE} will attempt to
resolve the date of the observation to a spring index, bloom value for the
location at which the observations was taken.}

\item{agdd_layer}{Numeric value, accepts \code{32} or \code{50}. When set, the results
will attempt to resolve the date of the observation to an AGDD value for
the location; the \code{32} or \code{50} represents the base value of the AGDD value
returned. All AGDD values are based on a January 1st start date of the year
in which the observation was taken.}

\item{six_sub_model}{Affects the results of the six layers returned. Can be
used to specify one of three submodels used to calculate the spring index
values. Thus setting this field will change the results of \code{six_leaf_layer}
and \code{six_bloom_layer}. Valid values include: \code{'lilac'}, \code{'zabelli'} and
\code{'arnoldred'}. For more information see the NPN's Spring Index Maps
documentation: \url{https://www.usanpn.org/data/maps/spring}.}

\item{additional_layers}{Data frame with first column named \code{name} and
containing the names of the layer for which to retrieve data and the second
column named \code{param} and containing string representations of the
time/elevation subset parameter to use. This variable can be used to append
additional geospatial layer data fields to the results, such that the date
of observation in each row will resolve to a value from the specified
layers, given the location of the observation.}

\item{wkt}{WKT geometry by which filter data. Specifying a valid WKT within
the contiguous US will filter data based on the locations which fall within
that WKT.}
}
\value{
A tibble of all status records returned as per the search
parameters. If \code{download_path} is specified, the file path is returned
instead.
}
\description{
This function allows for a parameterized search of all individual
phenometrics records in the USA-NPN database, returning all records as per
the search parameters in a data table. Data fetched from NPN services is
returned as raw JSON before being channeled into a data table. Optionally
results can be directed to an output file in which case raw JSON is converted
to CSV and saved to file; in that case, data is also streamed to file which
allows for more easily handling of the data if the search otherwise returns
more data than can be handled at once in memory.
}
\details{
This data type includes estimates of the dates of phenophase onsets and ends
for individual plants and for animal species at a site during a user-defined
time period. Each row represents a series of consecutive "yes" phenophase
status records, beginning with the date of the first "yes" and ending with
the date of the last "yes", submitted for a given phenophase on a given
organism. Note that more than one consecutive series for an organism may be
present within a single growing season or year.

Most search parameters are optional, however, users are encouraged to supply
additional search parameters to get results that are easier to work with.
\code{request_source} must be provided. This is a self-identifying string, telling
the service who is asking for the data or from where the request is being
made. It is recommended you provide your name or organization name. If the
call to this function is acting as an intermediary for a client, then you may
also optionally provide a user email and/or IP address for usage data
reporting later.

Additional fields provides the ability to specify additional, non-critical
fields to include in the search results. A complete list of additional fields
can be found in the NPN service's \href{https://docs.google.com/document/d/1yNjupricKOAXn6tY1sI7-EwkcfwdGUZ7lxYv7fcPjO8/edit#heading=h.7yy4i3278v7u}{companion documentation}
Metadata on all fields can be found in the following Excel sheet:
\url{https://www.usanpn.org/files/metadata/individual_phenometrics_datafield_descriptions.xlsx}
}
\examples{
\dontrun{
#Download all saguaro data for 2013 and 2014 using "water year" as the period
npn_download_individual_phenometrics(
  request_source = "Your Name or Org Here",
  years = c(2013, 2014),
  period_start = "10-01",
  period_end = "09-30",
  species_id = 210,
  download_path = "saguaro_data_2013_2014.csv"
)
}
}
