% Generated by roxygen2 (4.0.1): do not edit by hand
\name{GetStationSummary}
\alias{GetStationSummary}
\title{List of stations from UK NRFA}
\usage{
GetStationSummary(lonMin = -10, lonMax = 10, latMin = 48, latMax = 62,
  metadataColumn = NULL, entryValue = NULL, minRec = NULL)
}
\arguments{
\item{lonMin}{Minimum latitude of bounding box}

\item{lonMax}{Maximum latitude of bounding box}

\item{latMin}{Minimum longitude of bounding box}

\item{latMax}{Maximum longitude of bounding box}

\item{metadataColumn}{name of column to filter}

\item{entryValue}{string to search in metadataColumn#'}

\item{minRec}{minimum number of recording years}
}
\value{
data.frame with list of stations and related metadata
}
\description{
This function pulls the list of stations (and related metadata), falling within a given bounding box, from the CEH National River Flow Archive website.
}
\details{
coordinates of bounding box are required in WGS84 (EPSG: 4326). If BB coordinates are missing, the function returns the list corresponding to the maximum extent of the network.
}
\examples{
x <- GetStationSummary() # this returns all the stations in the network
x <- GetStationSummary(lonMin=-1, lonMax=1, latMin=49, latMax=51) # this returns 31 stations
}
\author{
Claudia Vitolo
}

