% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRFA_Catalogue.R
\name{NRFA_Catalogue}
\alias{NRFA_Catalogue}
\title{List of stations from UK NRFA}
\usage{
NRFA_Catalogue(bbox = NULL, metadataColumn = NULL, entryValue = NULL,
  minRec = NULL, verbose = FALSE)
}
\arguments{
\item{bbox}{this is a geographical bounding box (e.g. list(lonMin=-3.82, lonMax=-3.63, latMin=52.43, latMax=52.52))#'}

\item{metadataColumn}{name of column to filter}

\item{entryValue}{string to search in metadataColumn#'}

\item{minRec}{minimum number of recording years}

\item{verbose}{if TRUE prints warning messages}
}
\value{
data.frame with list of stations and related metadata
}
\description{
This function pulls the list of stations (and related metadata), falling within a given bounding box, from the CEH National River Flow Archive website.
}
\details{
coordinates of bounding box are required in WGS84 (EPSG: 4326). If BB coordinates are missing, the function returns the list corresponding to the maximum extent of the network.
}
\examples{
# Retrieve all the stations in the network (1537)
x <- NRFA_Catalogue()

# Define a bounding box:
# bbox <- list(lonMin=-3.82, lonMax=-3.63, latMin=52.43, latMax=52.52)
# x <- NRFA_Catalogue(bbox) # this returns 9 stations
# x <- NRFA_Catalogue(minRec=30) # this returns 1048 stations

}
\author{
Claudia Vitolo
}

