% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectRoads.R
\name{projectRoads}
\alias{projectRoads}
\alias{projectRoads,ANY,ANY,ANY,ANY,ANY,ANY,ANY,missing-method}
\alias{projectRoads,ANY,ANY,ANY,ANY,ANY,ANY,ANY,list-method}
\title{Project road network}
\usage{
projectRoads(
  landings = NULL,
  cost = NULL,
  roads = NULL,
  roadMethod = "mst",
  plotRoads = FALSE,
  mainTitle = "",
  neighbourhood = "octagon",
  sim = NULL,
  roadsOut = NULL,
  roadsInCost = TRUE,
  ordering = "closest"
)

\S4method{projectRoads}{ANY,ANY,ANY,ANY,ANY,ANY,ANY,missing}(
  landings = NULL,
  cost = NULL,
  roads = NULL,
  roadMethod = "mst",
  plotRoads = FALSE,
  mainTitle = "",
  neighbourhood = "octagon",
  sim = NULL,
  roadsOut = NULL,
  roadsInCost = TRUE,
  ordering = "closest"
)

\S4method{projectRoads}{ANY,ANY,ANY,ANY,ANY,ANY,ANY,list}(
  landings = NULL,
  cost = NULL,
  roads = NULL,
  roadMethod = "mst",
  plotRoads = FALSE,
  mainTitle = "",
  neighbourhood = "octagon",
  sim = NULL,
  roadsOut = NULL,
  roadsInCost = TRUE,
  ordering = "closest"
)
}
\arguments{
\item{landings}{sf polygons or points, RasterLayer, SpatialPolygons*,
SpatialPoints*, matrix, containing features to be connected
to the road network. Matrix should contain columns x, y with coordinates,
all other columns will be ignored.}

\item{cost}{RasterLayer. Cost surface where existing roads must be the only
cells with a cost of 0. If existing roads do not have 0 cost set
\code{roadsInCost = FALSE} and they will be burned in.}

\item{roads}{sf lines, SpatialLines*, RasterLayer. Existing road network.}

\item{roadMethod}{Character. Options are "mst", "dlcp", "lcp", "snap".}

\item{plotRoads}{Boolean. Should the resulting road network be plotted.
Default FALSE.}

\item{mainTitle}{Character. A title for the plot}

\item{neighbourhood}{Character. 'rook','queen', or 'octagon'. The cells that
should be considered adjacent. 'octagon' option is a modified version of
the queen's 8 cell neighbourhood in which diagonals weights are 2^0.5x
higher than horizontal/vertical weights.}

\item{sim}{list. Returned from a previous iteration of \code{projectRoads}.
cost, roads, and \code{roadMethod} are ignored if a \code{sim} list is provided.}

\item{roadsOut}{Character. Either "raster", "sf" or NULL. If "raster" roads
are returned as a raster in the \code{sim} list. If "sf" the roads are returned as
an sf object which will contain lines if the roads input was sf lines but a
geometry collection of lines and points if the roads input was a raster.
The points in the geometry collection represent the existing roads while
new roads are created as lines. If NULL (default) then the returned roads
are sf if the input is sf or Spatial* and raster if the input was a raster.}

\item{roadsInCost}{Logical. The default is TRUE which means the cost raster
is assumed to include existing roads as 0 in its cost surface. If FALSE
then the roads will be "burned in" to the cost raster with a cost of 0.}

\item{ordering}{character. The order in which roads should be built to
landings when `roadMethod = "dlcp"`. Options are "closest" (default) where
landings closest to existing roads are accessed first, or "none" where
landings are accessed in the order they are provided in.}
}
\value{
a list with components:
\itemize{
\item{roads: }{the projected road network, including new and input roads.}
\item{costSurface: }{the cost surface, updated to have 0 for new roads that
      were added.}
\item{roadMethod: }{the road simulation method used.}
\item{landings: }{the landings used in the simulation.}
\item{g: }{the graph that describes the cost of paths between each cell in the
      cost raster. This is updated based on the new roads so that vertices 
      were connected by new roads now have a cost of 0. This can be used to 
      avoid recomputing the graph in a simulation with multiple time steps.}
}
}
\description{
Project road locations based on existing roads, planned landings, and a cost
surface that defines the cost of building roads.
}
\details{
Four different methods for projecting road networks have been implemented:
\itemize{
  \item{"snap":} {Connects each landing directly to the closest road without
  reference to the cost or other landings}
  \item{"lcp":} {Least Cost Path connects each landing to the closest point
  on the road by determining the least cost path based on the cost surface
  provided, it does not consider other landings}
  \item{"dlcp":} {Dynamic Least Cost Path, same as "lcp" but it builds each
  path sequentially so that later roads will use earlier roads. The sequence
  of landings is determined by `ordering` and is "closest" by default, the
  other option is "none" which will use the order that landings are supplied
  in.}
  \item{"mst":} {Minimum Spanning Tree connects all landings to the road by
  determining the least cost path to the road or other landings based on the
  cost surface}
}
}
\examples{

doPlots <- interactive()

projectRoads(CLUSexample$landings, CLUSexample$cost, CLUSexample$roads,
             "lcp", plotRoads = doPlots, mainTitle = "CLUSexample")
                         

# More realistic examples that take longer to run
\donttest{
### using:  scenario 1 / sf landings / least-cost path ("lcp")
# demo scenario 1
scen <- demoScen[[1]]

# landing set 1 of scenario 1:
land.pnts <- scen$landings.points.sf[scen$landings.points.sf$set==1,]

prRes <- projectRoads(land.pnts, scen$cost.rast, scen$road.line.sf, "lcp",
                         plotRoads = doPlots, mainTitle = "Scen 1: SPDF-LCP")

### using: scenario 1 / RasterLayer landings / minimum spanning tree ("mst")
# demo scenario 1
scen <- demoScen[[1]]

# the RasterLayer version of landing set 1 of scenario 1:
land.rLyr <- scen$landings.stack[[1]]

prRes <- projectRoads(land.rLyr, scen$cost.rast, scen$road.line.sf, "mst",
                         plotRoads = doPlots, mainTitle = "Scen 1: Raster-MST")


### using: scenario 2 / matrix landings raster roads / snapping ("snap")
# demo scenario 2
scen <- demoScen[[2]]

# landing set 5 of scenario 2, as matrix:
land.mat  <- scen$landings.points[scen$landings.points$set==5,]@coords

prRes <- projectRoads(land.mat, scen$cost.rast, scen$road.rast, "snap",
                         plotRoads = doPlots, mainTitle = "Scen 2: Matrix-Snap")

## using scenario 7 / Polygon landings raster / minimum spanning tree
# demo scenario 7
scen <- demoScen[[7]]
# rasterize polygonal landings of demo scenario 7:
land.polyR <- raster::rasterize(scen$landings.poly, scen$cost.rast)

prRes <- projectRoads(land.polyR, scen$cost.rast, scen$road.rast, "mst",
                         plotRoads = doPlots, mainTitle = "Scen 7: PolyRast-MST")
}
}
