% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{methodCommunity}
\alias{methodCommunity}
\title{methodCommunity}
\usage{
methodCommunity(
  graph,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "other"),
  FUN = NULL,
  directed = FALSE,
  weights = NULL,
  steps = 4,
  spins = 25,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"optimal", "other".}

\item{FUN}{in case the @method parameter is "other" there is the possibility 
to use a personal function passing its name through this parameter.
The personal parameter has to take as input the @graph and the @weights 
(that can be NULL), and has to return a community object.}

\item{directed}{Logical constant, whether to calculate directed edge 
betweenness for directed graphs. This argument is settable only for 
"edgeBetweenness" method.}

\item{weights}{Optional positive weight vector. If the graph has a weight 
edge attribute, then this is used by default. Supply NA here if the graph 
has a weight edge attribute, but you want to ignore it. Larger edge weights
correspond to stronger connections. This argument is not settable for 
"infomap" method.}

\item{steps}{The number of steps to take, this is actually the number of 
tries to make a step. It is not a particularly useful parameter. This 
argument is settable only for "leadingEigen" and "walktrap" method.}

\item{spins}{Integer constant, the number of spins to use. This is the upper 
limit for the number of communities. It is not a problem to supply a 
(reasonably) big number here, in which case some spin states will be 
unpopulated. This argument is settable only for "spinglass" method.}

\item{e.weights}{If not NULL, then a numeric vector of edge weights. 
The length must match the number of edges in the graph. By default the 
‘weight’ edge attribute is used as weights. If it is not present, then all
edges are considered to have the same weight. Larger edge weights correspond 
to stronger connections. This argument is settable only for "infomap"
 method.}

\item{v.weights}{If not NULL, then a numeric vector of vertex weights. The
length must match the number of vertices in the graph. By default the 
‘weight’ vertex attribute is used as weights. If it is not present, then all
vertices are considered to have the same weight. A larger vertex weight means
a larger probability that the random surfer jumps to that vertex. This 
argument is settable only for "infomap" method.}

\item{nb.trials}{The number of attempts to partition the network (can be any
integer value equal or larger than 1). This argument is settable only for
"infomap" method.}
}
\value{
A Communities object.
}
\description{
This function detects the community structure of a graph.
To detect the community structure the user can choose one of the methods implemented 
in igraph.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
methodCommunity (graph=graph, method="louvain") 
}
