% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{membershipCommunities}
\alias{membershipCommunities}
\title{membershipCommunities}
\usage{
membershipCommunities(
  graph,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "leiden", "other"),
  ...,
  FUN = NULL
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"optimal", "leiden","other".}

\item{...}{additional parameters to use with any of the previous described 
methods (see igraph package community detection methods for more details 
i.e. \link[igraph]{cluster_walktrap})}

\item{FUN}{in case the @method parameter is "other" there is the possibility 
to use a personal function passing its name through this parameter.
The personal parameter has to take as input the @graph and the @weights 
(that can be NULL), and has to return a community object.}
}
\value{
Returns a numeric vector, one number for each vertex in the graph; 
the membership vector of the community structure.
}
\description{
This function computes the membership vector of the community 
structure. To detect the community structure the user can choose one of the methods implemented 
in igraph.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
membershipCommunities (graph=graph, method="louvain")
}
