% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN_external_function.R
\name{random}
\alias{random}
\title{random}
\usage{
random(graph, dist = "NegBinom", verbose = FALSE)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{dist}{Option to rewire in a manner that retains overall graph weight 
regardless of distribution of edge weights. This option is invoked by putting 
any text into this field. Defaults to "NegBinom" for negative binomial.}

\item{verbose}{flag for verbose output (default as FALSE)}
}
\value{
An igraph object, a randomly rewired graph.
}
\description{
This function randomly rewires the edges while preserving the original graph's 
degree distribution.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
}
