% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_weight_plot.R
\name{setup_weight_plot}
\alias{setup_weight_plot}
\alias{setup_weight_plot.test_mediation}
\alias{setup_weight_plot.reg_fit_mediation}
\title{Set up a diagnostic plot of robust regression weights}
\usage{
setup_weight_plot(object, ...)

\method{setup_weight_plot}{test_mediation}(object, ...)

\method{setup_weight_plot}{reg_fit_mediation}(object, outcome = NULL, npoints = 1000, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{fit_mediation}"}
or \code{"\link{test_mediation}"} containing results from robust mediation
analysis.  Only mediation analysis objects fitted with the robust
MM-estimator are supported.}

\item{\dots}{additional arguments to be passed down.}

\item{outcome}{a character vector specifying the outcome variables of the
regressions to be included in the plot.  This must be a subset of the
hypothesized mediators and the dependent variable, or \code{NULL} (the
default) to include all regressions of the mediation model.}

\item{npoints}{the number of grid points used to evaluate the expected
percentages.  The default is to use 1000 grid points.}
}
\value{
An object of class \code{"setup_weight_plot"} with the following
components:
\item{data}{a data frame containing the following information: the outcome
variable of the regression (column \code{Outcome}; only if multiple
regressions are to be included in the plot), whether the row corresponds to
the negative or the positive tail of the residual distribution (column
\code{Tail}), whether the row corresponds to the expected (under the normal
distribution) or the empirical weights (column \code{Weights}), the weight
thresholds (column \code{Threshold}), and the corresponding percentage of
observations that have a weight below this threshold (column
\code{Percentage}).}
\item{outcome}{a character vector containing the outcome variables of the
regressions to be included in the plot.}
}
\description{
Extract the relevant information for a diagnostic plot of the regression
weights from robust mediation analysis.  This plot allows to easily detect
deviations from normality assumptions such as skewness or heavy tails.
}
\details{
This function is used internally by \code{\link{weight_plot}()}.  It may
also be useful for users who want to produce a similar plot, but who want
more control over what information to display or how to display that
information.
}
\examples{
data("BSG2014")

# run fast-and-robust bootstrap test
test <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict")

# set up information for plot
setup <- setup_weight_plot(test)
# create diagnostic plot of robust regression weights
weight_plot(setup) +
  scale_color_manual("", values = c("black", "#00BFC4")) +
  theme(legend.position = "top")

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()},
\code{\link{weight_plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
