% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{weighted_quantile}
\alias{weighted_quantile}
\title{Weighted lower sample quantiles}
\usage{
weighted_quantile(x, w, probs, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector whose weighted sample quantiles are wanted}

\item{w}{a numeric vector of weights}

\item{probs}{a numeric vector of probabilities with values in [0,1]}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}
}
\value{
Weighted sample quantiles
}
\description{
\code{weighted_quantile} computes the weighted lower sample quantile
}
\details{
Weighted lower quantiles are computed using an algorithm with \eqn{O(n*log(n))}
in worst-case time. There exist superior algorithms; see Cormen et al.
(2009, Problem 9.2).
}
\examples{
x <- c(0.1, 0.35, 0.05, 0.1, 0.15, 0.05, 0.2)
weighted_quantile(x, x, probs = c(0.25, 0.5, 0.75))
}
\references{
Cormen,T.H., Leiserson, C.E., Rivest, R.L., and Stein, C. (2009):
   Introduction to Algorithms, 3rd ed., Cambridge: MIT Press.
}
\seealso{
\code{\link{weighted_median}}
}
