% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pair_scatter}
\alias{plot_pair_scatter}
\title{Plot Pairwise Gene Scatter Plot}
\usage{
plot_pair_scatter(environment, gene1, gene2, cluster_group1,
  cluster_group2, group1_label, group2_label, width = 10, height = 10)
}
\arguments{
\item{environment}{\code{environment} object}

\item{gene1}{selected gene number 1}

\item{gene2}{selected gene number 2}

\item{cluster_group1}{cluster group 1 to be visualized (one or more clusters)}

\item{cluster_group2}{cluster group 2 to be visualized (one or more clusters)}

\item{group1_label}{label for group 1 legend and file name}

\item{group2_label}{label for group 2 legend and file name}

\item{width}{pdf file canvas width}

\item{height}{pdf file canvas height}
}
\description{
Visualize normalized expression contours of a selected gene pair across selected cluster groups.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
cluster_names <- get.cluster.names(LCMV1, types, min.fold = 1.0, max.Qval = 0.01)
LCMV1 <- set.cluster.names(LCMV1, names = cluster_names)
plot_pair_scatter(LCMV1,
gene1 = 'Cd4',
gene2 = 'Cd8',
cluster_group1 = cluster_names[1:2],
cluster_group2 = cluster_names[3:4],
group1_label = 'CD4 T Cells',
group2_label = 'CD8 T Cells')
}
}
