% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMixedEffectDatasets.R
\name{generateMixedEffectDatasets}
\alias{generateMixedEffectDatasets}
\title{Generate Mixed Effects Datasets}
\usage{
generateMixedEffectDatasets(
  numberOfDatasetsToGenerate,
  preparedDataset,
  errorGenerator = rnorm,
  randomEffectGenerator = rnorm
)
}
\arguments{
\item{numberOfDatasetsToGenerate}{number of datasets to generate.}

\item{preparedDataset}{dataset as prepared by
\code{\link{prepareMixedEffectDataset}}.}

\item{errorGenerator}{random number generator used for the errors.}

\item{randomEffectGenerator}{random number generator used for the spherical
random effects.}
}
\value{
list with generators and the contents of the prepared dataset. See
  \code{\link{prepareMixedEffectDataset}} and
  \code{\link{generateAnovaDatasets}} for a description of the contents.
}
\description{
Generates mixed effects datasets using parametric bootstrap.
}
\examples{
  preparedDataset <- prepareMixedEffectDataset(Reaction ~ Days + (Days|Subject), sleepstudy)
  datasets <- generateMixedEffectDatasets(2, preparedDataset)
  head(datasets$generateData(1))
  head(datasets$generateData(2))
  datasets$formula
  head(datasets$randomEffects(1))
  head(datasets$sphericalRandomEffects(1))
  head(datasets$errors(1))
}
\seealso{
\code{\link{generateAnovaDatasets}},
  \code{\link{prepareMixedEffectDataset}} and
  \code{\link{createDatasetsFromList}}
}
\author{
Manuel Koller
}
