% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codingScheme.R
\docType{data}
\name{create_codingScheme}
\alias{create_codingScheme}
\alias{codingScheme_peterson}
\alias{codingScheme_levine}
\alias{codingScheme_willis}
\title{Create a coding scheme}
\format{
An object of class \code{rock_codingScheme} of length 5.

An object of class \code{rock_codingScheme} of length 5.

An object of class \code{rock_codingScheme} of length 5.
}
\usage{
create_codingScheme(
  id,
  label,
  codes,
  codingInstructions = NULL,
  description = "",
  source = ""
)

codingScheme_peterson

codingScheme_levine

codingScheme_willis
}
\arguments{
\item{id}{An identifier for this coding scheme, consisting only of
letters, numbers, and underscores (and not starting with a number).}

\item{label}{A short human-readable label for the coding scheme.}

\item{codes}{A character vector with the codes in this scheme.}

\item{codingInstructions}{Coding instructions; a named character vector,
where each element is a code's coding instruction, and each element's name
is the corresponding code.}

\item{description}{A description of this coding scheme (i.e. for information
that does not fit in the label).}

\item{source}{Optionally, a description, reference, or URL of a source
for this coding scheme.}
}
\value{
The coding scheme object.
}
\description{
This function can be used to specify a coding scheme that can then
be used in analysis.
}
\details{
A number of coding schemes for cognitive interviews are provided:

\describe{
\item{codingScheme_peterson}{Coding scheme from Peterson, Peterson &
Powell, 2017}
\item{codingScheme_levine}{Coding scheme from Levine, Fowler &
Brown, 2005}
\item{codingScheme_willis}{Coding scheme from Willis, 1999}
}
}
\keyword{datasets}
