% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultsOverview_allCodedFragments.R
\name{resultsOverview_allCodedFragments}
\alias{resultsOverview_allCodedFragments}
\title{Show all coded fragments}
\usage{
resultsOverview_allCodedFragments(
  x,
  root = "codes",
  context = 0,
  heading = NULL,
  headingLevel = 2,
  add_html_tags = TRUE,
  cleanUtterances = FALSE,
  output = NULL,
  outputViewer = "viewer",
  template = "default",
  includeCSS = TRUE,
  includeBootstrap = rock::opts$get("includeBootstrap"),
  preventOverwriting = rock::opts$get(preventOverwriting),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{x}{The parsed source(s) as provided by \code{rock::parse_source}
or \code{rock::parse_sources}.}

\item{root}{The root code}

\item{context}{How many utterances before and after the target
utterances to include in the fragments.}

\item{heading}{Optionally, a title to include in the output. The title
will be prefixed with \code{headingLevel} hashes (\verb{#}), and the codes with
\code{headingLevel+1} hashes. If \code{NULL} (the default), a heading will be
generated that includes the collected codes if those are five or less.
If a character value is specified, that will be used. To omit a heading,
set to anything that is not \code{NULL} or a character vector (e.g. \code{FALSE}).
If no heading is used, the code prefix will be \code{headingLevel} hashes,
instead of \code{headingLevel+1} hashes.}

\item{headingLevel}{The number of hashes to insert before the headings.}

\item{add_html_tags}{Whether to add HTML tags to the result.}

\item{cleanUtterances}{Whether to use the clean or the raw utterances
when constructing the fragments (the raw versions contain all codes). Note that
this should be set to \code{FALSE} to have \code{add_html_tags} be of the most use.}

\item{output}{Here, a path and filename can be provided where the
result will be written. If provided, the result will be returned
invisibly.}

\item{outputViewer}{If showing output, where to show the output: in
the console (\code{outputViewer='console'}) or in the viewer
(\code{outputViewer='viewer'}), e.g. the RStudio viewer. You'll usually want
the latter when outputting HTML, and otherwise the former. Set to \code{FALSE}
to not output anything to the console or the viewer.}

\item{template}{The template to load; either the name of one
of the ROCK templates (currently, only 'default' is available), or
the path and filename of a CSS file.}

\item{includeCSS}{Whether to include the ROCK CSS in the returned HTML.}

\item{includeBootstrap}{Whether to include the default bootstrap CSS.}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}
}
\value{
Invisibly, the coded fragments in a character vector.
}
\description{
Show all coded fragments
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(
    examplePath, "example-1.rock"
  );

### Parse single example source
parsedExample <-
  rock::parse_source(
    exampleFile
  );

### Show organised coded fragments in Markdown
cat(
  rock::resultsOverview_allCodedFragments(
    parsedExample
  )
);

}
