% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_delete.R
\name{recode_delete}
\alias{recode_delete}
\title{Remove one or more codes}
\usage{
recode_delete(
  input,
  codes,
  filter = TRUE,
  output = NULL,
  filenameRegex = ".*",
  outputPrefix = "",
  outputSuffix = "_rcDeleted",
  childrenReplaceParents = TRUE,
  recursiveDeletion = FALSE,
  decisionLabel = NULL,
  justification = NULL,
  justificationFile = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{One of 1) a character string specifying the path to a file
with a source; 2) an object with a loaded source as produced by a call
to \code{\link[=load_source]{load_source()}}; 3) a character string specifying the path to a directory
containing one or more sources; 4) or an object with a list of loaded
sources as produced by a call to \code{\link[=load_sources]{load_sources()}}.}

\item{codes}{A character vector with codes to remove.}

\item{filter}{Optionally, a filter to apply to specify a subset of the
source(s) to process (see \code{\link[=get_source_filter]{get_source_filter()}}).}

\item{output}{If specified, the recoded source(s) will be written here.}

\item{filenameRegex}{Only process files matching this regular expression.}

\item{outputPrefix}{The prefix and suffix to add to the
filenames when writing the processed files to disk, in case multiple
sources are passed as input.}

\item{outputSuffix}{The prefix and suffix to add to the
filenames when writing the processed files to disk, in case multiple
sources are passed as input.}

\item{childrenReplaceParents}{Whether children should be deleted (\code{FALSE})
or take their parent code's place (\code{TRUE}). This is ignored if
\code{recursiveDeletion=TRUE}, in which case children are always deleted.}

\item{recursiveDeletion}{Whether to also delete a code's parents (\code{TRUE}),
if they have no other children, and keep doing this until the root is
reached, or whether to leave parent codes alone (\code{FALSE}). This takes
precedence over \code{childrenReplaceParents}.}

\item{decisionLabel}{A description of the (recoding) decision that was taken.}

\item{justification}{The justification for this action.}

\item{justificationFile}{If specified, the justification is appended to
this file. If not, it is saved to the \code{justifier::workspace()}. This can
then be saved or displayed at the end of the R Markdown file or R script
using \code{justifier::save_workspace()}.}

\item{preventOverwriting}{Whether to prevent overwriting existing files
when writing the files to \code{output}.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}
}
\value{
Invisibly, the recoded source(s) or source(s) object.
}
\description{
These functions remove one or more codes from a source, and make it easy to
justify that decision.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExample <- rock::load_source(exampleFile);

### Delete two codes, moving children to the codes' parents
recoded_source <-
  rock::recode_delete(
    loadedExample,
    codes=c("childCode2", "childCode1"),
    silent=FALSE
  );

### Process an entire directory
list_of_recoded_sources <-
  rock::recode_delete(
    examplePath,
    codes=c("childCode2", "childCode1"),
    silent=FALSE
  );

}
