% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorrelatedData.R
\name{vech2mat}
\alias{vech2mat}
\title{Convert a half-vector (vech) into a matrix.}
\usage{
vech2mat(vech, diag = NULL, lowerOnly = FALSE)
}
\arguments{
\item{vech}{A vector}

\item{diag}{Optional. A single value or a vector for the
diagonal. A vech is a strictly lower triangluar vech, it
does not include diagonal values. diag can be either a single
value (to replace all elements along the diagonal) or a vector of
the correct length to replace the diagonal.}

\item{lowerOnly}{Default = FALSE.}
}
\description{
Fills a matrix from a vector that represents the lower triangle.
If user does not supply a value for diag, then the vech will fill
in the diagonal as well as the strictly lower triangle.  If diag
is provided (either a number or a vector), then vech is for the
strictly lower triangular part.  The default value for lowerOnly
is FALSE, which means that a symmetric matrix will be created. See
examples for a demonstration of how to fill in the lower triangle
and leave the diagonal and the upper triangle empty.
}
\examples{
x <- 1:6
vech2mat(x)
vech2mat(x, diag = 7)
vech2mat(x, diag = c(99, 98, 97, 96))
vech2mat(x, diag = 0, lowerOnly = TRUE)
}
\seealso{
Similar functions exist in many packages, see
\code{vec2sm} in corpcor, \code{xpnd} in MCMCpack
}

