% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classMethods_arrange.r
\name{arrangePars}
\alias{arrangePars}
\title{Assign Values to Parameters}
\arguments{
\item{x}{A list of values to be assigned to the model's parameters.
The elements of \code{x} are either numeric scalars (for
single box models) or vectors (for multi-box models). In the latter case,
the length of the vector(s) must be equal to the number of modeled boxes
(e.g. layers in a vertical 1D model).
If scalars and vectors are present, the scalars will be turned into vectors
by replication.}

\item{sep}{A character string used to create element names for the return
vector in multi-box models (i.e. if some element(s) of \code{x} are
vectors). Element names of the return vector are constructed by appending
the level index (starting from 1) to the name of the respective list
element using the value of \code{sep} as a separator. In the single-box
case, \code{sep} is ignored, and the elements of the return vector carry
the same names as the corresponding list elements.}

\item{warnUnused}{Logical. If \code{TRUE}, a warning is issued if \code{x}
  an element name in \code{x} does not match the name of a parameter.
  Setting this to \code{FALSE} allows \code{x} to contain auxiliary data.}
}
\value{
Named numeric vector with elements being ordered for compatibility
  with the respective \code{\link{rodeo}} object. The returned vector can be
  passed to the \code{parms} argument of \code{\link[deSolve]{ode}}, for
  example.
}
\description{
Assign values to parameters of a \code{\link{rodeo}}-based model.
}
\note{
No additional notes so far.
}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
p= model$arrangePars(list(kd=5.78e-7, h_do=0.5, s_do_z=2.76, wind=1, depth=2,
  temp=20, q_in=1, q_ex=1))
print(p)
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
Other methods of the \code{\link{rodeo-class}}
}

