% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plainMethod_solverInterface.r
\name{solverInterface}
\alias{solverInterface}
\title{Wrapping of Generated Fortran for Use with Solver Packages}
\usage{
solverInterface(NLVL = 1, funcname = "derivs", outname = "derivs_wrapped")
}
\arguments{
\item{NLVL}{The desired number of spatial levels (boxes). Defaults to 1.}

\item{funcname}{Name of the function for which a wrapper is to be created
(rather than the name for the wrapper). It is assumed that a function with
that name was (or will be) created by a call to the \code{\link{generate}}
class method.}

\item{outname}{Name for the created wrapper function.}
}
\value{
A character string holding generated Fortran code. Must be written to
  disk, e.g. using \code{\link[base]{write}} prior to compilation. The
  generated code provides two subroutines.
  The first subroutine with the fixed name 'initmod' is to be passed to
  the \code{initfunc} argument of, e.g., method \code{\link[deSolve]{ode}}
  (from package \code{\link[deSolve]{deSolve-package}}) or
  \code{\link[rootSolve]{steady}} (from package
  \code{\link[rootSolve]{rootSolve-package}}).
  The second subroutine whose name is given by \code{outname} is to be passed
  to the \code{func} argument of the \code{\link[deSolve]{deSolve}} or
  \code{\link[rootSolve]{rootSolve}} methods.
}
\description{
Creates wrapper code to make \code{rodeo}-generated Fortran code compatible
with the numerical methods from packages \code{\link[deSolve]{deSolve}} and
\code{\link[rootSolve]{rootSolve}}. Consider to use the
\code{\link{rodeo-class}} class method \code{\link{compile}} instead of this
low-level function.
}
\examples{
fortranCode= solverInterface(NLVL=3)
write(fortranCode, file="")
}
\author{
David Kneis \email{david.kneis@tu-dresden.de}
}
\seealso{
The \code{\link{rodeo-class}} method \code{\link{compile}} is a
  convenient high-level function that calls \code{\link{solverInterface}}
  internally.
}

