% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/classMethod_stoichiometry.r
\name{stoichiometry}
\alias{stoichiometry}
\title{Return the Stoichiometry Matrix}
\arguments{
\item{values}{A named numeric vector specifying the values of all state
  variables and parameters. For non-autonomous models, there must also be an
  element named 'time'. If \code{values} is set to \code{NULL}, the
  mathematical expressions are not evaluated but returned as character
  strings.}
}
\value{
A matrix of numeric or character type, depending on the contents of
 \code{values}.
}
\description{
Return and optionally evaluate the mathematical expression appearing in the
stoichiometry matrix.
}
\note{
If the stoichiometric factors are mathematical expressions involving
  function references, these functions must be defined in R (even if the
  numerical computations are based on generated Fortran code).
}
\examples{
data(exampleIdentifiers, exampleProcesses, exampleStoichiometry)
model= new("rodeo",
  vars=subset(exampleIdentifiers, type=="v"),
  pars=subset(exampleIdentifiers, type=="p"),
  funs=subset(exampleIdentifiers, type=="f"),
  pros=exampleProcesses, stoi=exampleStoichiometry
)
print(model$stoichiometry())
c_z_in= function(time) {0.1}
c_do_in= function(time) {8.0}
print(model$stoichiometry(c(s_do_z=2.76, c_z=1, c_do=9.022, time=0)))
}
\author{
\email{david.kneis@tu-dresden.de}
}
\seealso{
See other methods of the \code{\link{rodeo-class}} or
  \code{\link{plotStoichiometry}} for a graphical representation of the
  stoichiometric factors only.
}

