% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethods_setValues.r
\name{setVars}
\alias{setVars}
\title{Assign Values to State Variables}
\arguments{
\item{x}{A numeric vector or array, depending on the model's spatial
dimensions. See details below.}
}
\value{
\code{NULL} (invisible). The assigned numeric data are stored in the
  object and can be accessed by the \code{\link{getVars}} method.
}
\description{
Assign values to state variables of a \code{\link{rodeo}}-based model.
}
\note{
For a 0-dimensional model (i.e. a model without spatial resolution),
  \code{x} must be a numeric vector whose length equals the number of state
  variables. The element names of \code{x} must match those returned by the
  object's \code{namesVars} method. See the examples for how to bring the
  vector elements into required order.

  For models with a spatial resolution, \code{x} must be a numeric array of
  proper dimensions. The last dimension (cycling slowest) corresponds to the
  variables and the first dimension (cycling fastest) corresponds to the
  models' highest spatial dimension. Thus, \code{dim(x)} must be equal to
  \code{c(rev(obj$getDim()), obj$namesVars())} where \code{obj} is the object
  whose variables are to be assigned. The names of the array's last dimension
  must match the return value of  \code{obj$namesVars()}.

  In the common 1-dimensional case, this just means that \code{x} must be a
  matrix with column names matching the return value of
  \code{obj$namesVars()} and as many rows as given by \code{obj$getDim()}.
}
\examples{
data(vars, pars, funs, pros, stoi)
x0 <- c(bac=0.1, sub=0.5)

# 0-dimensional model
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(1))
model$setVars(x0)
print(model$getVars())

# How to sort vector elements
x0 <- c(sub=0.5, bac=0.1)              # doesn't match order of variables
model$setVars(x0[model$namesVars()])

# 1-dimensional model with 3 boxes
nBox <- 3
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(nBox))
x1 <- matrix(rep(x0, each=nBox), nrow=nBox, ncol=model$lenVars(),
  dimnames=list(NULL, model$namesVars()))
model$setVars(x1)
print(model$getVars())
print(model$getVars(asArray=TRUE))

# 2-dimensional model with 3 x 4 boxes
model <- rodeo$new(vars, pars, funs, pros, stoi, dim=c(3,4))
x2 <- array(rep(x0, each=3*4), dim=c(4,3,model$lenVars()),
  dimnames=list(dim2=NULL, dim1=NULL, variables=model$namesVars()))
model$setVars(x2)
print(model$getVars())
print(model$getVars(asArray=TRUE))
}
\seealso{
The corresponding 'get' method is \code{\link{getVars}}. Use
  \code{\link{setPars}} to assign values to parameters rather than variables.
}
\author{
\email{david.kneis@tu-dresden.de}
}
