% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mrs_cause_schema}
\alias{mrs_cause_schema}
\title{Star schema for Mortality Reporting System by Cause}
\format{
A \code{star_schema} object.
}
\usage{
mrs_cause_schema
}
\description{
Definition of schemas for facts and dimensions for the Mortality Reporting System
considering the cause classification.
}
\details{
Dimension schemes can be defined using variables so that you do not have to repeat
the definition in several multidimensional designs.
}
\examples{
# Defined by:

when <- dimension_schema(name = "When",
                         attributes = c("Year"))
where <- dimension_schema(name = "Where",
                          attributes = c("REGION",
                                         "State",
                                         "City"))
mrs_cause_schema <- star_schema() |>
  define_facts(name = "MRS Cause",
               measures = c("Pneumonia and Influenza Deaths",
                            "All Deaths")) |>
  define_dimension(when) |>
  define_dimension(where)

}
\seealso{
\code{\link{ft_num}}

Other mrs example schema: 
\code{\link{mrs_age_schema}}
}
\concept{mrs example schema}
\keyword{datasets}
