% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ft_age}
\alias{ft_age}
\title{Mortality Reporting System by Age Group}
\format{
A \code{tibble}.
}
\source{
\url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
}
\usage{
ft_age
}
\description{
Selection data from the 122 Cities Mortality Reporting System by age group.
}
\details{
The original dataset covers from 1962 to 2016. For each week, in 122 US cities,
mortality figures by age group and cause, considered separately, are included.
}
\examples{
# The operations to obtain it from the `ft` data set are:

if (rlang::is_installed("stringr")) {
  ft_age <- ft |>
    dplyr::select(-`Pneumonia and Influenza Deaths`, -`All Deaths`) |>
    tidyr::gather("Age", "All Deaths", 7:11) |>
    dplyr::mutate(`All Deaths` = as.integer(`All Deaths`)) |>
    dplyr::mutate(Age = stringr::str_replace(Age, " \\\\(all cause deaths\\\\)", ""))
}

}
\seealso{
\code{\link{mrs_age_schema}}

Other mrs example data: 
\code{\link{ft_age_rpd}},
\code{\link{ft_cause_rpd}},
\code{\link{ft_num}},
\code{\link{ft}}
}
\concept{mrs example data}
\keyword{datasets}
