% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{transactions_db}
\alias{transactions_db}
\title{Czech debit card company specialising on payments at gas stations (tables)}
\format{
A \code{star_database}.
}
\source{
\url{https://relational.fit.cvut.cz/dataset/CCS}
}
\usage{
transactions_db
}
\description{
Data base in \code{dm} format with a summary from the data available at the source.
}
\details{
The development has been done in the vignette \code{vignette("v20-rdbms-dm")}.
}
\examples{
# Defined by:
\donttest{
ccs_db <- RMariaDB::dbConnect(
  RMariaDB::MariaDB(),
  username = "guest",
  password = "relational",
  dbname = "ccs",
  host = "relational.fit.cvut.cz"
)
ccs_dm <- dm::dm_from_con(ccs_db, learn_keys = TRUE)
ccs_sel_dm <-
  ccs_dm[c('transactions_1k', 'customers', 'gasstations', 'products')] |>
  dm::dm_add_fk(transactions_1k, CustomerID, customers) |>
  dm::dm_add_fk(transactions_1k, GasStationID, gasstations) |>
  dm::dm_add_fk(transactions_1k, ProductID, products)
transactions_db <- ccs_sel_dm |>
  dm::collect()
DBI::dbDisconnect(ccs_db)
}

}
\seealso{
Other database example data: 
\code{\link{db_finest}},
\code{\link{db_summary}}
}
\concept{database example data}
\keyword{datasets}
