% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{cancel_deployment}
\alias{cancel_deployment}
\alias{cancel_deployment.star_database}
\title{Cancel deployment}
\usage{
cancel_deployment(db, name)

\method{cancel_deployment}{star_database}(db, name)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{name}{A string, name of the deployment.}
}
\value{
A \code{star_database} object.
}
\description{
Cancel deployment
}
\examples{

mrs_rdb_file <- tempfile("mrs", fileext = ".rdb")
mrs_sqlite_file <- tempfile("mrs", fileext = ".sqlite")

mrs_sqlite_connect <- function() {
  DBI::dbConnect(RSQLite::SQLite(),
                 dbname = mrs_sqlite_file)
}

mrs_db <- mrs_db |>
  deploy(
    name = "mrs",
    connect = mrs_sqlite_connect,
    file = mrs_rdb_file
  )

mrs_db <- mrs_db |>
  cancel_deployment(name = "mrs")

}
\seealso{
\code{\link{star_database}}

Other star database deployment functions: 
\code{\link{deploy}()},
\code{\link{get_deployment_names}()},
\code{\link{load_star_database}()}
}
\concept{star database deployment functions}
