% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_query.R
\name{filter_dimension}
\alias{filter_dimension}
\alias{filter_dimension.star_query}
\title{Filter dimension}
\usage{
filter_dimension(sq, name, ...)

\method{filter_dimension}{star_query}(sq, name = NULL, ...)
}
\arguments{
\item{sq}{A \code{star_query} object.}

\item{name}{A string, name of the dimension.}

\item{...}{Conditions, defined in exactly the same way as in \code{dplyr::filter}.}
}
\value{
A \code{star_query} object.
}
\description{
Allows you to define selection conditions for dimension rows.
}
\details{
Conditions can be defined on any attribute of the dimension (not only on
attributes selected in the query for the dimension). The selection is made
based on the function \code{dplyr::filter}. Conditions are defined in exactly the
same way as in that function.
}
\examples{

sq <- mrs_db |>
  star_query() |>
  filter_dimension(name = "when", week <= " 3") |>
  filter_dimension(name = "where", city == "Cambridge")

}
\seealso{
Other query functions: 
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{star_query}()}
}
\concept{query functions}
