% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoattribute.R
\name{get_geoattributes}
\alias{get_geoattributes}
\alias{get_geoattributes.star_database}
\title{Get geoattributes}
\usage{
get_geoattributes(db)

\method{get_geoattributes}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A list of dimension geoattributes.
}
\description{
For each dimension, get a list of available geoattributes.
}
\examples{

db <- mrs_db |>
  define_geoattribute(
    dimension = "where",
    attribute = "state",
    from_layer = us_layer_state,
    by = "STUSPS"
  )

attributes <- db |>
    get_geoattributes()

}
\seealso{
Other star database geographic attributes: 
\code{\link{check_geoattribute_geometry}()},
\code{\link{define_geoattribute}()},
\code{\link{get_geoattribute_geometries}()},
\code{\link{get_layer_geometry}()},
\code{\link{get_point_geometry}()},
\code{\link{summarize_layer}()}
}
\concept{star database geographic attributes}
