% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolog.R
\name{query}
\alias{query}
\title{Create a query}
\usage{
query(
  query = call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE,
    expression(Y))),
  options = NULL
)
}
\arguments{
\item{query}{an R call. The R call consists of symbols, integers and real numbers,
character strings, boolean values, expressions, lists, and other calls.
Vectors of booleans, integers, floating point numbers, and strings with
length \emph{N} > 1 are translated to prolog compounds !/N, \%/N, #/N and $$/N,
respectively. The names can be modified with the options below.}

\item{options}{This is a list of options controlling translation from and to prolog.
\itemize{
\item \emph{boolvec} (see option rolog.boolvec, default is !) is the name of the
prolog compound for vectors of booleans.
\item \emph{intvec}, \emph{realvec}, \emph{charvec} define the compound names for vectors of
integers, doubles and strings, respectively (defaults are \%, # and $$).
\item If \emph{scalar} is \code{TRUE} (default), vectors of length 1 are translated to
scalar prolog elements. If \emph{scalar} is \code{FALSE}, vectors of length 1 are
also translated to compounds.
}}
}
\value{
If the creation of the query succeeds, \code{TRUE}.
}
\description{
Create a query
}
\details{
SWI-Prolog does not allow multiple open queries. If another query is open, it
it is closed and a warning is shown.
}
\examples{
query(call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE, expression(Y))))
submit() # X = a
submit() # X = "b"
clear()

# The same in simplified syntax
q <- quote(member(.X, ""[a, "b", 3L, 4, TRUE, .Y]))
query(as.rolog(q))
submit() # X = a
submit() # X = "b"
clear()

query(call("member", expression(X), list(quote(a), "b", 3L, 4, TRUE, expression(Y))))
submit() # X = 3L
submit() # X = 4.0
submit() # X = TRUE
submit() # X = expression(Y) or Y = expression(X)
submit() # FALSE
submit() # warning that no query is open

query(call("member", expression(X), list(quote(a), "b", 3L, 4)))
query(call("member", expression(X), list(TRUE, expression(Y)))) # warning that another query is open
clear()

}
\seealso{
\code{\link[=once]{once()}} for a query that is submitted only a single time.

\code{\link[=findall]{findall()}} for a query that is submitted until it fails.
}
